/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.FileAppender;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.FileManager;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.RollingFileAppender;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.NoOpTriggeringPolicy;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.layout.PatternLayout;
import com.newrelic.agent.logging.ClearExpiredLogsRunnable;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FileAppenderFactory {
    private static final int MIN_FILE_COUNT = 1;
    private static final boolean APPEND_TO_FILE = true;
    private static final String DAILY_CRON = "0 0 0 * * ?";
    static final String FILE_APPENDER_NAME = "File";
    private static final long INITIAL_DELAY_SECONDS = 60L;
    private static final int REPEAT_INTERVAL_SECONDS = 86400;
    private final int fileCount;
    private final long logLimitBytes;
    private final String fileName;
    private final boolean isDaily;
    private final String path;

    public FileAppenderFactory(int fileCount, long logLimitBytes, String fileName, boolean isDaily, String path) {
        this.fileCount = fileCount;
        this.logLimitBytes = logLimitBytes;
        this.fileName = fileName;
        this.isDaily = isDaily;
        this.path = path;
    }

    AbstractOutputStreamAppender<? extends FileManager> build() {
        AbstractOutputStreamAppender<? extends FileManager> rollingFileAppender = this.buildRollingFileAppender();
        rollingFileAppender.start();
        return rollingFileAppender;
    }

    private AbstractOutputStreamAppender<? extends FileManager> buildRollingFileAppender() {
        if (this.isDaily) {
            return this.buildDailyRollingAppender();
        }
        if (this.logLimitBytes > 0L) {
            return ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)this.initializeRollingFileAppender().withStrategy(DefaultRolloverStrategy.newBuilder().withMin(String.valueOf(1)).withMax(String.valueOf(Math.max(1, this.fileCount))).build())).withPolicy(this.sizeBasedPolicy())).withFilePattern(this.fileName + ".%i")).build();
        }
        return this.buildDefaultFileAppender(this.fileName);
    }

    private AbstractOutputStreamAppender<? extends FileManager> buildDefaultFileAppender(String fileName) {
        return ((FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder()).withFileName(fileName)).withAppend(true)).setName(FILE_APPENDER_NAME)).setLayout(PatternLayout.newBuilder().withPattern("%d{ISO8601_OFFSET_DATE_TIME_HHMM} [%pid %tid] %logger %marker: %m%n").build())).build();
    }

    private RollingFileAppender buildDailyRollingAppender() {
        TriggeringPolicy policy = this.buildRollingAppenderTriggeringPolicy();
        DefaultRolloverStrategy rolloverStrategy = DefaultRolloverStrategy.newBuilder().withMax(String.valueOf(this.fileCount)).build();
        String filePattern = this.fileName + ".%d{yyyy-MM-dd}";
        if (this.logLimitBytes > 0L) {
            filePattern = this.fileName + ".%d{yyyy-MM-dd}.%i";
        }
        Path directory = new File(this.path).toPath();
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread2 = new Thread(runnable);
            thread2.setName("New Relic Expiring Log File Cleanup");
            thread2.setDaemon(true);
            return thread2;
        });
        executorService.scheduleWithFixedDelay(new ClearExpiredLogsRunnable(this.fileCount, this.fileName), 60L, 86400L, TimeUnit.SECONDS);
        return ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)this.initializeRollingFileAppender().withPolicy(policy)).withFilePattern(filePattern)).withStrategy(rolloverStrategy)).build();
    }

    private TriggeringPolicy buildRollingAppenderTriggeringPolicy() {
        TimeBasedTriggeringPolicy timeBasedTriggeringPolicy = TimeBasedTriggeringPolicy.newBuilder().withInterval(1).withModulate(true).build();
        TriggeringPolicy sizeBasedTriggeringPolicy = this.sizeBasedPolicy();
        return CompositeTriggeringPolicy.createPolicy(timeBasedTriggeringPolicy, sizeBasedTriggeringPolicy);
    }

    private RollingFileAppender.Builder initializeRollingFileAppender() {
        return (RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder()).withFileName(this.fileName)).withAppend(true)).setName(FILE_APPENDER_NAME)).setLayout(PatternLayout.newBuilder().withPattern("%d{ISO8601_OFFSET_DATE_TIME_HHMM} [%pid %tid] %logger %marker: %m%n").build());
    }

    private TriggeringPolicy sizeBasedPolicy() {
        return this.logLimitBytes > 0L ? SizeBasedTriggeringPolicy.createPolicy(String.valueOf(this.logLimitBytes)) : NoOpTriggeringPolicy.createPolicy();
    }
}

