/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LimitedSizeHashMap<K, V>
implements Map<K, V> {
    private final int max;
    private final Map<K, V> map;

    public LimitedSizeHashMap(int max) {
        this.max = max;
        this.map = new HashMap();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.map.size() < this.max) {
            return this.map.put(key, value);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        for (Map.Entry<K, V> entry : m4.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
            if (this.map.size() < this.max) continue;
            return;
        }
    }

    public void putAllIfAbsent(Map<? extends K, ? extends V> m4) {
        for (Map.Entry<K, V> entry : m4.entrySet()) {
            if (this.map.containsKey(entry.getKey())) continue;
            this.put(entry.getKey(), entry.getValue());
            if (this.map.size() < this.max) continue;
            return;
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitedSizeHashMap that = (LimitedSizeHashMap)o;
        return this.max == that.max && Objects.equals(this.map, that.map);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.max, this.map);
    }
}

