/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import java.text.MessageFormat;
import java.util.logging.Level;

public class PriorityTransactionName {
    public static final PriorityTransactionName NONE = PriorityTransactionName.create(null, null, TransactionNamePriority.NONE);
    public static final String WEB_TRANSACTION_CATEGORY = "Web";
    public static final String UNDEFINED_TRANSACTION_CATEGORY = "Other";
    private final TransactionNamePriority priority;
    private final String prefix;
    private final String partialName;
    private final String category;
    private final String cachedName;

    private PriorityTransactionName(String prefix, String partialName, String category, TransactionNamePriority priority) {
        this.prefix = prefix == null ? this.getPrefix() : prefix;
        this.partialName = partialName;
        this.category = category;
        this.priority = priority;
        this.cachedName = this.prefix + partialName;
    }

    private String initializeName(String partialName) {
        String prefix = this.getPrefix();
        if (prefix == null) {
            return null;
        }
        if (partialName == null) {
            return prefix;
        }
        if (!prefix.equals(this.prefix)) {
            return prefix + partialName;
        }
        return this.cachedName;
    }

    public String getName() {
        return this.initializeName(this.partialName);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPartialName() {
        return this.partialName;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isFrozen() {
        return this.priority == TransactionNamePriority.FROZEN;
    }

    public PriorityTransactionName freeze() {
        Agent.LOG.log(Level.FINEST, "Setting priority transaction name to FROZEN: {0}", this.toString());
        if (this.isFrozen()) {
            return this;
        }
        return PriorityTransactionName.create(this.getPrefix(), this.getPartialName(), this.category, TransactionNamePriority.FROZEN);
    }

    public TransactionNamePriority getPriority() {
        return this.priority;
    }

    public String toString() {
        return MessageFormat.format("{0}[name={1}, priority={2}]", this.getClass().getName(), this.getName(), this.getPriority());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.partialName == null ? 0 : this.partialName.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriorityTransactionName)) {
            return false;
        }
        PriorityTransactionName other = (PriorityTransactionName)obj;
        String name = this.getName();
        String otherName = other.getName();
        if (name == null ? otherName != null : !name.equals(otherName)) {
            return false;
        }
        return this.priority.equals((Object)other.priority);
    }

    public static PriorityTransactionName create(String transactionName, String category, TransactionNamePriority priority) {
        if (transactionName == null) {
            return new PriorityTransactionName(null, null, category, priority);
        }
        int index = transactionName.indexOf(47, 1);
        if (index > 0 && (index = transactionName.indexOf(47, index + 1)) > 0) {
            String prefix = transactionName.substring(0, index);
            String partialName = transactionName.substring(index);
            return new PriorityTransactionName(prefix, partialName, category, priority);
        }
        return new PriorityTransactionName(transactionName, null, category, priority);
    }

    public static PriorityTransactionName create(final Transaction tx, String partialName, String category, TransactionNamePriority priority) {
        if (priority == null) {
            return null;
        }
        if (category == null || category.isEmpty()) {
            category = tx.isWebTransaction() ? WEB_TRANSACTION_CATEGORY : UNDEFINED_TRANSACTION_CATEGORY;
        }
        return new PriorityTransactionName(null, partialName, category, priority){

            @Override
            public String getPrefix() {
                return tx.isWebTransaction() ? "WebTransaction" : "OtherTransaction";
            }
        };
    }

    public static PriorityTransactionName create(String prefix, String partialName, String category, TransactionNamePriority priority) {
        if (priority == null) {
            return null;
        }
        return new PriorityTransactionName(prefix, partialName, category, priority);
    }
}

