/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport.apache;

import com.newrelic.agent.deps.org.apache.http.HttpHost;
import com.newrelic.agent.deps.org.apache.http.auth.AuthScope;
import com.newrelic.agent.deps.org.apache.http.auth.Credentials;
import com.newrelic.agent.deps.org.apache.http.auth.UsernamePasswordCredentials;
import com.newrelic.agent.deps.org.apache.http.client.protocol.HttpClientContext;
import com.newrelic.agent.deps.org.apache.http.impl.client.BasicCredentialsProvider;
import com.newrelic.agent.deps.org.apache.http.protocol.HttpContext;
import com.newrelic.api.agent.Logger;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ApacheProxyManager {
    private final HttpHost proxy;
    private final Credentials proxyCredentials;
    private final Logger logger;

    public ApacheProxyManager(String proxyHost, Integer proxyPort, String proxyScheme, String proxyUser, String proxyPassword, Logger logger) {
        this.logger = logger;
        if (proxyHost != null && proxyPort != null) {
            logger.log(Level.FINE, MessageFormat.format("Using proxy host {0}:{1}", proxyHost, Integer.toString(proxyPort)));
            this.proxy = new HttpHost(proxyHost, (int)proxyPort, proxyScheme);
            this.proxyCredentials = this.getProxyCredentials(proxyUser, proxyPassword);
        } else {
            this.proxy = null;
            this.proxyCredentials = null;
        }
    }

    private Credentials getProxyCredentials(String proxyUser, String proxyPass) {
        if (proxyUser != null && proxyPass != null) {
            this.logger.log(Level.INFO, MessageFormat.format("Setting Proxy Authenticator for user {0}", proxyUser));
            return new UsernamePasswordCredentials(proxyUser, proxyPass);
        }
        return null;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public HttpContext updateContext(HttpClientContext httpClientContext) {
        if (this.proxy != null && this.proxyCredentials != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.proxy), this.proxyCredentials);
            httpClientContext.setCredentialsProvider(credentialsProvider);
        }
        return httpClientContext;
    }
}

