/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.bridge.CollectionFactory;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Cache;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class AgentCollectionFactory
implements CollectionFactory {
    public <K, V> Map<K, V> createConcurrentWeakKeyedMap() {
        Cache cache = Caffeine.newBuilder().initialCapacity(32).weakKeys().executor(Runnable::run).build();
        return cache.asMap();
    }

    public <K, V> Map<K, V> createConcurrentTimeBasedEvictionMap(long ageInSeconds) {
        Cache cache = Caffeine.newBuilder().initialCapacity(32).expireAfterWrite(ageInSeconds, TimeUnit.SECONDS).executor(Runnable::run).build();
        return cache.asMap();
    }

    public <K, V> Function<K, V> memorize(Function<K, V> loader, int maxSize) {
        LoadingCache<Object, Object> cache = Caffeine.newBuilder().maximumSize(maxSize).executor(Runnable::run).build(loader::apply);
        return cache::get;
    }

    public <K, V> Function<K, V> createAccessTimeBasedCache(long ageInSeconds, int initialCapacity, Function<K, V> loader) {
        LoadingCache<Object, Object> cache = Caffeine.newBuilder().initialCapacity(initialCapacity).expireAfterAccess(ageInSeconds, TimeUnit.SECONDS).build(loader::apply);
        return cache::get;
    }
}

