/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.jfr.daemon.BufferedTelemetry;
import com.newrelic.jfr.daemon.EventConverter;
import com.newrelic.jfr.daemon.RecordedEventBuffer;
import com.newrelic.jfr.daemon.TelemetrySender;
import com.newrelic.telemetry.events.EventBatch;
import com.newrelic.telemetry.metrics.MetricBatch;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jfr.consumer.RecordingFile;

public final class JFRUploader {
    private static final Logger logger = LoggerFactory.getLogger(JFRUploader.class);
    private final TelemetrySender telemetrySender;
    private final RecordedEventBuffer eventBuffer;
    private volatile EventConverter eventConverter;

    public JFRUploader(TelemetrySender telemetrySender, RecordedEventBuffer eventBuffer) {
        this.telemetrySender = telemetrySender;
        this.eventBuffer = eventBuffer;
    }

    public void handleFile(Path dumpFile) {
        try {
            this.bufferFileData(dumpFile);
            this.maybeDrainAndSend();
        }
        catch (Exception e) {
            logger.error("Error handling raw dump file", e);
        }
        finally {
            this.deleteFile(dumpFile);
            this.deleteFile(dumpFile.getParent());
        }
    }

    public void readyToSend(EventConverter eventConverter) {
        logger.info("JFR Uploader is ready to send events.");
        this.eventConverter = eventConverter;
    }

    private void bufferFileData(Path dumpFile) {
        try (RecordingFile recordingFile = this.openRecordingFile(dumpFile);){
            this.eventBuffer.bufferEvents(dumpFile, recordingFile);
        }
        catch (Throwable t2) {
            logger.error("Error processing file " + dumpFile, t2);
        }
    }

    private void maybeDrainAndSend() {
        if (this.eventConverter == null) {
            logger.warn("Drain attempt skipped because JFRUploader is not yet ready to send.");
            return;
        }
        BufferedTelemetry telemetry = this.eventConverter.convert(this.eventBuffer);
        this.sendMetrics(telemetry);
        this.sendEvents(telemetry);
    }

    private void sendMetrics(BufferedTelemetry bufferedMetrics) {
        MetricBatch metricBatch = bufferedMetrics.createMetricBatch();
        if (!metricBatch.isEmpty()) {
            logger.debug("Sending metric batch of size {}", (Object)metricBatch.size());
            this.telemetrySender.sendBatch(metricBatch);
        }
    }

    private void sendEvents(BufferedTelemetry bufferedMetrics) {
        EventBatch eventBatch = bufferedMetrics.createEventBatch();
        if (!eventBatch.isEmpty()) {
            logger.debug("Sending events batch of size {}", (Object)eventBatch.size());
            this.telemetrySender.sendBatch(eventBatch);
        }
    }

    public static int countMatches(String text, String str) {
        Matcher matcher = Pattern.compile(str).matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    RecordingFile openRecordingFile(Path file) {
        try {
            return new RecordingFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening recording file", e);
        }
    }

    void deleteFile(Path dumpFile) {
        try {
            Files.delete(dumpFile);
            logger.debug("JFR daemon deleted file/path: {}", (Object)dumpFile);
        }
        catch (Exception e) {
            File file = dumpFile.toFile();
            logger.debug("JFR daemon did not delete file/path {} with permissions: r: {}, w: {}, x: {}", file, file.canRead(), file.canWrite(), file.canExecute());
        }
    }

    public Instant fileStart() {
        return this.eventBuffer.start();
    }

    public Instant fileEnd() {
        return this.eventBuffer.end();
    }
}

