/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.profiler;

import com.newrelic.jfr.profiler.FlameLevel;
import com.newrelic.jfr.profiler.FlamegraphMarshaller;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class FrameFlattener {
    public List<FlameLevel> flatten(FlamegraphMarshaller.StackFrame stackFrame) {
        List<FlameLevel> frames = this.addChildren(stackFrame, null, new AtomicInteger(0));
        return frames;
    }

    private List<FlameLevel> addChildren(FlamegraphMarshaller.StackFrame current, FlameLevel parent, AtomicInteger idGenerator) {
        if (current == null) {
            return Collections.emptyList();
        }
        String parentId = parent == null ? "null" : parent.getId();
        String id = current.getName();
        FlameLevel currentNewFlameLevel = new FlameLevel(current.getName(), current.getValue(), parentId, id);
        LinkedList<FlameLevel> flattenedResult = new LinkedList<FlameLevel>();
        flattenedResult.add(currentNewFlameLevel);
        if (current.getChildren() == null) {
            return flattenedResult;
        }
        for (FlamegraphMarshaller.StackFrame child : current.getChildren()) {
            flattenedResult.addAll(this.addChildren(child, currentNewFlameLevel, idGenerator));
        }
        return flattenedResult;
    }
}

