/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.tosummary.BaseDurationSummarizer;
import java.time.Duration;
import java.util.function.Supplier;
import jdk.jfr.consumer.RecordedEvent;

public class PairSummarizer
extends BaseDurationSummarizer {
    public PairSummarizer(long startTimeMs, Supplier<Long> defaultClock, String duration) {
        super(startTimeMs, defaultClock, duration);
    }

    public void accept(RecordedEvent before, RecordedEvent after) {
        Duration pairDuration = Duration.ofMillis(after.getStartTime().toEpochMilli() - before.getStartTime().toEpochMilli());
        this.endTimeMs = after.getStartTime().toEpochMilli();
        this.duration = this.duration.plus(pairDuration);
        if (pairDuration.compareTo(this.maxDuration) > 0) {
            this.maxDuration = pairDuration;
        }
        if (pairDuration.compareTo(this.minDuration) < 0) {
            this.minDuration = pairDuration;
        }
    }
}

