/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.ClassInformationFinder;
import com.newrelic.weave.utils.WeaveUtils;
import java.io.IOException;

class PatchedClassWriter
extends ClassWriter {
    private static final String JAVA_LANG_THROWABLE = "java/lang/Throwable";
    private static final String JAVA_LANG_EXCEPTION = "java/lang/Exception";
    private final ClassInformationFinder classInfoFinder;

    PatchedClassWriter(int flags, ClassInformationFinder classInfoFinder) {
        super(flags);
        this.classInfoFinder = classInfoFinder;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(type2)) {
            return type1;
        }
        String commonSuperType = null;
        try {
            String type2Super;
            String type1Super;
            ClassInformation type1CI = this.classInfoFinder.getClassInformation(type1);
            ClassInformation type2CI = this.classInfoFinder.getClassInformation(type2);
            String[] type1Supers = null == type1CI ? new String[]{} : type1CI.getAllSuperNames(this.classInfoFinder).toArray(new String[0]);
            String[] type2Supers = null == type2CI ? new String[]{} : type2CI.getAllSuperNames(this.classInfoFinder).toArray(new String[0]);
            int type1Index = type1Supers.length - 1;
            for (int type2Index = type2Supers.length - 1; type1Index >= -1 && type2Index >= -1 && (type1Super = type1Index >= 0 ? type1Supers[type1Index] : type1).equals(type2Super = type2Index >= 0 ? type2Supers[type2Index] : type2); --type1Index, --type2Index) {
                commonSuperType = type1Super;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == commonSuperType) {
            if (PatchedClassWriter.areThrowableAndException(type1, type2)) {
                return JAVA_LANG_THROWABLE;
            }
            return WeaveUtils.JAVA_LANG_OBJECT_NAME;
        }
        return commonSuperType;
    }

    private static boolean areThrowableAndException(String type1, String type2) {
        return type1.equals(JAVA_LANG_THROWABLE) && type2.equals(JAVA_LANG_EXCEPTION) || type2.equals(JAVA_LANG_THROWABLE) && type1.equals(JAVA_LANG_EXCEPTION);
    }
}

