/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.deps.com.google.common.io.Resources;
import com.newrelic.agent.deps.org.apache.logging.log4j.Level;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.Configuration;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.Configurator;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import com.newrelic.agent.logging.IAgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.Log4jLogger;
import com.newrelic.agent.logging.LogFileHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

class Log4jLogManager
implements IAgentLogManager {
    private static final String AGENT_JAR_LOG4J_CONFIG_FILE = "/META-INF/logging/log4j2.xml";
    private static final String CONFIG_FILE_PROP = "log4j2.configurationFile";
    private static final String LEGACY_CONFIG_FILE_PROP = "log4j.configurationFile";
    private static final String CONTEXT_SELECT_PROP = "log4j2.contextSelector";
    private static final String LEGACY_CONTEXT_SELECT_PROP = "Log4jContextSelector";
    private static final String CONTEXT_FACTORY_PROP = "log4j2.loggerContextFactory";
    private static final String DISABLE_JMX_PROP = "log4j2.disableJmx";
    private static final String LEGACY_DISABLE_JMX_PROP = "log4j2.disable.jmx";
    private static final String CLASSLOADER_PROP = "log4j2.ignoreTCL";
    private static final String LEGACY_CLASSLOADER_PROP = "log4j.ignoreTCL";
    private static final String JAVA_UTIL_LOG_MANAGER = "java.util.logging.manager";
    private static final String WS_LOG_MANAGER = "WsLogManager";
    private final Log4jLogger rootLogger;
    private volatile String logFilePath;

    private Log4jLogManager(String name) {
        this.rootLogger = this.initializeRootLogger(name);
    }

    private Log4jLogger createRootLogger(String name) {
        Log4jLogger logger = Log4jLogger.create(name, true);
        String logLevel = this.getStartupLogLevel();
        logger.setLevel(logLevel);
        logger.addConsoleAppender();
        return logger;
    }

    private String getStartupLogLevel() {
        String propName = "newrelic.config.startup_log_level";
        String logLevel = System.getProperty(propName);
        if (logLevel == null) {
            return Level.INFO.toString().toLowerCase();
        }
        return logLevel.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Log4jLogger initializeRootLogger(String name) {
        Log4jLogger logger;
        block9: {
            logger = null;
            HashMap<String, String> systemProps = new HashMap<String, String>();
            try {
                String jarFileName = AgentJarHelper.getAgentJarFileName();
                if (jarFileName == null) {
                    logger = Log4jLogger.create(name, true);
                    break block9;
                }
                this.clearAllLog4jSystemProperties(systemProps);
                System.setProperty(CONTEXT_FACTORY_PROP, "com.newrelic.agent.deps.org.apache.logging.log4j.core.impl.Log4jContextFactory");
                System.setProperty(DISABLE_JMX_PROP, "true");
                System.setProperty(LEGACY_DISABLE_JMX_PROP, "true");
                System.setProperty(LEGACY_CLASSLOADER_PROP, "true");
                System.setProperty(CLASSLOADER_PROP, "true");
                if (Boolean.getBoolean("newrelic.config.agent_root_logger_init_with_file") || Boolean.parseBoolean(System.getenv("NEW_RELIC_AGENT_ROOT_LOGGER_INIT_WITH_FILE"))) {
                    this.initLog4jViaFile(jarFileName);
                } else {
                    this.initLog4jViaConfigurationBuilder();
                }
                try {
                    logger = this.createRootLogger(name);
                }
                finally {
                    System.getProperties().remove(CONFIG_FILE_PROP);
                    System.getProperties().remove(LEGACY_CONFIG_FILE_PROP);
                    System.getProperties().remove(CONTEXT_FACTORY_PROP);
                    System.getProperties().remove(DISABLE_JMX_PROP);
                    System.getProperties().remove(LEGACY_DISABLE_JMX_PROP);
                    System.getProperties().remove(CLASSLOADER_PROP);
                    System.getProperties().remove(LEGACY_CLASSLOADER_PROP);
                    this.applyOriginalSystemProperties(systemProps, logger);
                }
            }
            catch (Exception e) {
                if (logger == null) {
                    logger = this.createRootLogger(name);
                }
                String msg = MessageFormat.format("Error setting log4j.configurationFile property: {0}", e);
                logger.warning(msg);
            }
        }
        return logger;
    }

    private void clearAllLog4jSystemProperties(Map<String, String> storedSystemProps) {
        String logManagerProp = System.getProperty(JAVA_UTIL_LOG_MANAGER);
        if (logManagerProp != null && !logManagerProp.contains(WS_LOG_MANAGER)) {
            this.clearLog4jSystemProperty(JAVA_UTIL_LOG_MANAGER, storedSystemProps);
        }
        this.clearLog4jSystemProperty(CONFIG_FILE_PROP, storedSystemProps);
        this.clearLog4jSystemProperty(LEGACY_CONFIG_FILE_PROP, storedSystemProps);
        this.clearLog4jSystemProperty(CONTEXT_SELECT_PROP, storedSystemProps);
        this.clearLog4jSystemProperty(LEGACY_CONTEXT_SELECT_PROP, storedSystemProps);
        this.clearLog4jSystemProperty(CONTEXT_FACTORY_PROP, storedSystemProps);
        this.clearLog4jSystemProperty(DISABLE_JMX_PROP, storedSystemProps);
        this.clearLog4jSystemProperty(LEGACY_DISABLE_JMX_PROP, storedSystemProps);
        this.clearLog4jSystemProperty(CLASSLOADER_PROP, storedSystemProps);
        this.clearLog4jSystemProperty(LEGACY_CLASSLOADER_PROP, storedSystemProps);
    }

    private void clearLog4jSystemProperty(String prop, Map<String, String> storedSystemProps) {
        String old = System.clearProperty(prop);
        if (old != null) {
            storedSystemProps.put(prop, old);
        }
    }

    private void applyOriginalSystemProperties(Map<String, String> storedSystemProps, Log4jLogger logger) {
        for (Map.Entry<String, String> currentProp : storedSystemProps.entrySet()) {
            try {
                System.setProperty(currentProp.getKey(), currentProp.getValue());
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Error setting log4j property {0} back to {1}. Error: {2}", currentProp.getKey(), currentProp.getValue(), e);
                logger.warning(msg);
            }
        }
    }

    @Override
    public IAgentLogger getRootLogger() {
        return this.rootLogger;
    }

    @Override
    public String getLogFilePath() {
        return this.logFilePath;
    }

    @Override
    public void configureLogger(AgentConfig pAgentConfig) {
        this.configureLogLevel(pAgentConfig);
        this.configureConsoleHandler(pAgentConfig);
        this.configureFileHandler(pAgentConfig);
    }

    private void configureFileHandler(AgentConfig agentConfig) {
        String logFileName = this.getLogFileName(agentConfig);
        if (logFileName == null) {
            return;
        }
        this.rootLogger.addConsoleAppender();
        if (this.canWriteLogFile(logFileName)) {
            this.configureFileHandler(logFileName, agentConfig);
        } else {
            this.rootLogger.warning(MessageFormat.format("New Relic Agent: Unable to write log file: {0}. Please check permissions on the file and directory.", logFileName));
        }
    }

    private String getLogFileName(AgentConfig agentConfig) {
        File logFile = LogFileHelper.getLogFile(agentConfig);
        return logFile == null ? null : logFile.getPath();
    }

    private void configureLogLevel(AgentConfig agentConfig) {
        if (agentConfig.isDebugEnabled()) {
            this.rootLogger.setLevel(Level.TRACE.toString().toLowerCase());
        } else {
            this.rootLogger.setLevel(agentConfig.getLogLevel());
        }
    }

    private void configureConsoleHandler(AgentConfig agentConfig) {
        if (agentConfig.isDebugEnabled() || agentConfig.isLoggingToStdOut()) {
            this.addConsoleHandler();
        } else {
            this.rootLogger.removeConsoleAppender();
        }
    }

    private void configureFileHandler(String logFileName, AgentConfig agentConfig) {
        this.rootLogger.info(MessageFormat.format("New Relic Agent: Writing to log file: {0}", logFileName));
        this.rootLogger.removeConsoleAppender();
        int limit = agentConfig.getLogLimit() * 1024;
        int fileCount = Math.max(1, agentConfig.getLogFileCount());
        String path = LogFileHelper.getLogFile(agentConfig).getParent();
        boolean isDaily = agentConfig.isLogDaily();
        this.rootLogger.addFileAppender(logFileName, limit, fileCount, isDaily, path);
        this.logFilePath = logFileName;
        String msg = MessageFormat.format("Writing to New Relic log file: {0}", logFileName);
        this.rootLogger.info(msg);
        this.rootLogger.info(MessageFormat.format("JRE vendor {0} version {1}", System.getProperty("java.vendor"), System.getProperty("java.version")));
        this.rootLogger.info(MessageFormat.format("JVM vendor {0} {1} version {2}", System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version")));
        this.rootLogger.fine(MessageFormat.format("JVM runtime version {0}", System.getProperty("java.runtime.version")));
        this.rootLogger.info(MessageFormat.format("OS {0} version {1} arch {2}", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
    }

    private boolean canWriteLogFile(String logFileName) {
        try {
            File logFile = new File(logFileName);
            if (!logFile.exists()) {
                if (null != logFile.getParentFile()) {
                    logFile.getParentFile().mkdirs();
                }
                logFile.createNewFile();
            }
            return logFile.canWrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initLog4jViaConfigurationBuilder() {
        ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("Default");
        builder.add(builder.newRootLogger(Level.INFO));
        builder.setShutdownHook("disable");
        builder.add(builder.newLogger("com.newrelic.agent.deps.org.reflections", Level.OFF));
        Configurator.initialize((Configuration)builder.build());
    }

    private void initLog4jViaFile(String jarFileName) throws MalformedURLException {
        URL log4jConfigXmlUrl = null;
        if (jarFileName.endsWith(".jar")) {
            log4jConfigXmlUrl = new URL("jar:file:" + jarFileName + "!" + AGENT_JAR_LOG4J_CONFIG_FILE);
        } else {
            try {
                log4jConfigXmlUrl = Resources.getResource(this.getClass(), AGENT_JAR_LOG4J_CONFIG_FILE);
            }
            catch (IllegalArgumentException iae) {
                log4jConfigXmlUrl = new File(jarFileName).toURI().toURL();
            }
        }
        System.setProperty(CONFIG_FILE_PROP, log4jConfigXmlUrl.toString());
        System.setProperty(LEGACY_CONFIG_FILE_PROP, log4jConfigXmlUrl.toString());
    }

    @Override
    public void addConsoleHandler() {
        this.rootLogger.addConsoleAppender();
    }

    @Override
    public void setLogLevel(String pLevel) {
        this.rootLogger.setLevel(pLevel);
    }

    @Override
    public String getLogLevel() {
        return this.rootLogger.getLevel();
    }

    public static Log4jLogManager create(String name) {
        return new Log4jLogManager(name);
    }
}

