/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.JarResource;
import com.newrelic.agent.instrumentation.pointcuts.InterfaceMapper;
import com.newrelic.agent.instrumentation.pointcuts.InterfaceMixin;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.jmx.metrics.JmxInit;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class Annotations {
    private static Map<Object, Collection<Class<?>>> annotatedClasses;

    public Collection<Class<?>> getInterfaceMapperClasses() {
        return Annotations.getAnnotationClassesFromManifest(InterfaceMapper.class);
    }

    public Collection<Class<?>> getInterfaceMixinClasses() {
        return Annotations.getAnnotationClassesFromManifest(InterfaceMixin.class);
    }

    public Collection<Class<?>> getPointCutAnnotatedClasses() {
        return Annotations.getAnnotationClassesFromManifest(PointCut.class);
    }

    public Collection<Class<?>> getJmxInitClasses() {
        return Annotations.getAnnotationClassesFromManifest(JmxInit.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Class<?>> getAnnotationClassesFromManifest(Class<? extends Annotation> annotationClass) {
        Class<Annotations> clazz = Annotations.class;
        synchronized (Annotations.class) {
            if (annotatedClasses == null) {
                annotatedClasses = Annotations.buildAnnotatedClasses();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return annotatedClasses.containsKey(annotationClass.getName()) ? annotatedClasses.get(annotationClass.getName()) : Collections.emptySet();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<Object, Collection<Class<?>>> buildAnnotatedClasses() {
        HashMap classes = new HashMap();
        Properties props = new Properties();
        try (JarResource agentJarFile = AgentJarHelper.getAgentJarResource();
             InputStream is = agentJarFile.getInputStream("PointcutClasses.properties");){
            if (is == null) {
                HashMap hashMap = classes;
                return hashMap;
            }
            props.load(is);
            Iterator<Object> iterator2 = props.keySet().iterator();
            while (iterator2.hasNext()) {
                String[] annotatedClassNames;
                Object annotationClassName = iterator2.next();
                Object value = props.get(annotationClassName);
                if (!(value instanceof String)) continue;
                LinkedList annotatedClassList = new LinkedList();
                for (String annotatedClassName : annotatedClassNames = ((String)value).split(",")) {
                    annotatedClassList.add(AgentBridge.getAgent().getClass().getClassLoader().loadClass(annotatedClassName));
                }
                classes.put(annotationClassName, annotatedClassList);
            }
            return classes;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, e, "Unable to load pointcut classes");
            return classes;
        }
    }
}

