/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.api.agent.Config;
import com.newrelic.api.agent.NewRelic;

public class SecurityAgentConfig {
    public static final String SECURITY_AGENT_ENABLED = "security.agent.enabled";
    public static final boolean SECURITY_AGENT_ENABLED_DEFAULT = false;
    public static final String SECURITY_ENABLED = "security.enabled";
    public static final boolean SECURITY_ENABLED_DEFAULT = false;
    public static final String SECURITY_LOW_PRIORITY_INSTRUMENTATION_ENABLED = "security.low-priority-instrumentation.enabled";
    public static final boolean SECURITY_LOW_PRIORITY_INSTRUMENTATION_ENABLED_DEFAULT = false;
    public static final String SECURITY_MODE = "security.mode";
    public static final String SECURITY_MODE_DEFAULT = "IAST";
    public static final String SECURITY_VALIDATOR_SERVICE_URL = "security.validator_service_url";
    public static final String SECURITY_VALIDATOR_SERVICE_URL_DEFAULT = "wss://csec.nr-data.net";
    public static final String SECURITY_DETECTION_RCI_ENABLED = "security.detection.rci.enabled";
    public static final boolean SECURITY_DETECTION_RCI_ENABLED_DEFAULT = true;
    public static final String SECURITY_DETECTION_RXSS_ENABLED = "security.detection.rxss.enabled";
    public static final boolean SECURITY_DETECTION_RXSS_ENABLED_DEFAULT = true;
    public static final String SECURITY_DETECTION_DESERIALIZATION_ENABLED = "security.detection.deserialization.enabled";
    public static final boolean SECURITY_DETECTION_DESERIALIZATION_ENABLED_DEFAULT = true;
    private static final Config config = NewRelic.getAgent().getConfig();
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";

    public static void addSecurityAgentConfigSupportabilityMetrics() {
        String enabled = SecurityAgentConfig.isSecurityEnabled() ? ENABLED : DISABLED;
        NewRelic.incrementCounter((String)("Supportability/Java/SecurityAgent/Enabled/" + enabled));
        String agentEnabled = SecurityAgentConfig.isSecurityAgentEnabled() ? ENABLED : DISABLED;
        NewRelic.incrementCounter((String)("Supportability/Java/SecurityAgent/Agent/Enabled/" + agentEnabled));
    }

    public static boolean shouldInitializeSecurityAgent() {
        return (Boolean)config.getValue("high_security", (Object)false) == false && (Boolean)config.getValue(SECURITY_AGENT_ENABLED, (Object)false) != false && config.getValue(SECURITY_ENABLED) != null;
    }

    public static boolean isSecurityAgentEnabled() {
        return (Boolean)config.getValue(SECURITY_AGENT_ENABLED, (Object)false) != false && (Boolean)config.getValue("high_security", (Object)false) == false;
    }

    public static boolean isSecurityEnabled() {
        return (Boolean)config.getValue(SECURITY_ENABLED, (Object)false) != false && (Boolean)config.getValue("high_security", (Object)false) == false;
    }

    public static boolean isSecurityDetectionRciEnabled() {
        return (Boolean)config.getValue(SECURITY_DETECTION_RCI_ENABLED, (Object)true);
    }

    public static boolean isSecurityDetectionRxssEnabled() {
        return (Boolean)config.getValue(SECURITY_DETECTION_RXSS_ENABLED, (Object)true);
    }

    public static boolean isSecurityDetectionDeserializationEnabled() {
        return (Boolean)config.getValue(SECURITY_DETECTION_DESERIALIZATION_ENABLED, (Object)true);
    }

    public static String getSecurityAgentValidatorServiceUrl() {
        return (String)config.getValue(SECURITY_VALIDATOR_SERVICE_URL, (Object)SECURITY_VALIDATOR_SERVICE_URL_DEFAULT);
    }

    public static String getSecurityAgentMode() {
        return (String)config.getValue(SECURITY_MODE, (Object)SECURITY_MODE_DEFAULT);
    }

    public static boolean isSecurityLowPriorityInstrumentationEnabled() {
        return (Boolean)config.getValue(SECURITY_LOW_PRIORITY_INSTRUMENTATION_ENABLED, (Object)false);
    }
}

