/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedStackTrace;

public final class MethodSupport {
    private static final int JSON_SCHEMA_VERSION = 1;
    static final int HEADROOM_75PC = 3072;

    public static String describeMethod(RecordedMethod method) {
        if (method == null) {
            return "[missing]";
        }
        String typeName = method.getType().getName();
        String methodName = method.getName();
        String descriptor = method.getDescriptor();
        StringBuilder sb = new StringBuilder(typeName.length() + methodName.length() + descriptor.length() + 1);
        sb.append(typeName).append('.').append(methodName).append(descriptor);
        return sb.toString();
    }

    public static String empty() {
        List<RecordedFrame> payload = Collections.emptyList();
        try {
            return new String(MethodSupport.jsonWrite(payload, Optional.empty()).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate stacktrace json", e);
        }
    }

    public static String serialize(RecordedStackTrace trace) {
        if (trace == null) {
            return null;
        }
        try {
            return new String(MethodSupport.jsonWrite(trace.getFrames(), Optional.empty()).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate stacktrace json", e);
        }
    }

    public static String jsonWrite(List<RecordedFrame> frames, Optional<Integer> limit) throws IOException {
        StringWriter strOut = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(strOut);
        int frameCount = Math.min(limit.orElse(frames.size()), frames.size());
        jsonWriter.beginObject();
        jsonWriter.name("type").value("stacktrace");
        jsonWriter.name("language").value("java");
        jsonWriter.name("version").value(1L);
        jsonWriter.name("truncated").value(frameCount < frames.size());
        jsonWriter.name("payload").beginArray();
        for (int i = 0; i < frameCount; ++i) {
            RecordedFrame frame = frames.get(i);
            jsonWriter.beginObject();
            jsonWriter.name("desc").value(MethodSupport.describeMethod(frame.getMethod()));
            jsonWriter.name("line").value(Integer.toString(frame.getLineNumber()));
            jsonWriter.name("bytecodeIndex").value(Integer.toString(frame.getBytecodeIndex()));
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
        String out = strOut.toString();
        int length = out.length();
        if (length > 3072) {
            double percentageOfFramesToTry = 3072.0 / (double)length;
            int numFrames = (int)((double)frameCount * percentageOfFramesToTry);
            if (numFrames < frameCount) {
                return MethodSupport.jsonWrite(frames, Optional.of(numFrames));
            }
            throw new IOException("Corner case of a stack frame that can't be cleanly truncated! numFrames = " + numFrames + ", frameCount = " + frameCount + ", , percentageOfFramesToTry = " + percentageOfFramesToTry + ", length = " + length);
        }
        return out;
    }
}

