/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.newrelic.jfr.ThreadNameNormalizer;
import com.newrelic.jfr.tosummary.BasicGarbageCollectionSummarizer;
import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.G1GarbageCollectionSummarizer;
import com.newrelic.jfr.tosummary.GCHeapSummarySummarizer;
import com.newrelic.jfr.tosummary.NetworkReadSummarizer;
import com.newrelic.jfr.tosummary.NetworkWriteSummarizer;
import com.newrelic.jfr.tosummary.ObjectAllocationInNewTLABSummarizer;
import com.newrelic.jfr.tosummary.ObjectAllocationOutsideTLABSummarizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ToSummaryRegistry {
    private final List<EventToSummary> mappers;

    private static final List<EventToSummary> allMappers() {
        return ToSummaryRegistry.allMappers(null);
    }

    private static final List<EventToSummary> allMappers(ThreadNameNormalizer nameNormalizer) {
        return Arrays.asList(new BasicGarbageCollectionSummarizer(), new G1GarbageCollectionSummarizer(), new GCHeapSummarySummarizer(), new NetworkReadSummarizer(nameNormalizer), new NetworkWriteSummarizer(nameNormalizer), new ObjectAllocationInNewTLABSummarizer(nameNormalizer), new ObjectAllocationOutsideTLABSummarizer(nameNormalizer));
    }

    private ToSummaryRegistry(List<EventToSummary> mappers) {
        this.mappers = mappers;
    }

    public static ToSummaryRegistry create(ThreadNameNormalizer nameNormalizer) {
        return new ToSummaryRegistry(ToSummaryRegistry.allMappers(nameNormalizer));
    }

    static ToSummaryRegistry create(Collection<String> eventNames) {
        List<EventToSummary> filtered = ToSummaryRegistry.allMappers().stream().filter(mapper -> eventNames.contains(mapper.getEventName())).collect(Collectors.toList());
        return new ToSummaryRegistry(filtered);
    }

    private static List<String> allEventNames() {
        return ToSummaryRegistry.allMappers().stream().map(EventToSummary::getEventName).collect(Collectors.toList());
    }

    public Stream<EventToSummary> all() {
        return this.mappers.stream();
    }

    public Optional<EventToSummary> get(String eventName) {
        return this.mappers.stream().filter(m -> m.getEventName().equals(eventName)).findFirst();
    }
}

