/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.http.HttpResponse;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpPoster
implements HttpPoster {
    private final OkHttpClient okHttpClient;

    public OkHttpPoster(Duration callTimeout) {
        this(null, null, callTimeout);
    }

    public OkHttpPoster(Proxy proxy, Authenticator proxyAuthenticator, Duration callTimeout) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().callTimeout(callTimeout);
        if (proxy != null) {
            builder.proxy(proxy);
            if (proxyAuthenticator != null) {
                builder.authenticator(proxyAuthenticator);
            }
        }
        this.okHttpClient = builder.build();
    }

    @Override
    public HttpResponse post(URL url, Map<String, String> headers, byte[] body, String mediaType) throws IOException {
        RequestBody requestBody = RequestBody.create(body, MediaType.get(mediaType));
        Request request = new Request.Builder().url(url).headers(Headers.of(headers)).post(requestBody).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            HttpResponse httpResponse = new HttpResponse(response.body() != null ? response.body().string() : null, response.code(), response.message(), response.headers().toMultimap());
            return httpResponse;
        }
    }
}

