/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordedEventBuffer {
    private static final Logger logger = LoggerFactory.getLogger(RecordedEventBuffer.class);
    private final BlockingQueue<RecordedEvent> queue;
    private final RawProcessingContext ctx = new RawProcessingContext();

    public RecordedEventBuffer(BlockingQueue<RecordedEvent> queue) {
        this.queue = queue;
    }

    public void bufferEvents(Path dumpFile, RecordingFile file) throws IOException {
        this.ctx.resetForNewFile();
        if (logger.isDebugEnabled()) {
            logger.debug("Looking in " + dumpFile + " for events after: " + this.ctx.getLastSeen());
        }
        while (file.hasMoreEvents()) {
            RecordedEvent event = file.readEvent();
            if (this.handleEvent(event)) continue;
            logger.warn("Ignoring remaining events in this file due to full queue!");
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Queued events from: " + this.ctx.getFirstEventTime() + " to " + this.ctx.getLastEventTime() + " [" + this.ctx.getLastSeen() + "] in " + dumpFile);
        }
    }

    private boolean handleEvent(RecordedEvent event) {
        this.ctx.update(event);
        if (event.getStartTime().isAfter(this.ctx.getLastSeen())) {
            return this.enqueue(event);
        }
        return true;
    }

    private boolean enqueue(RecordedEvent event) {
        boolean success = this.queue.offer(event);
        if (!success) {
            logger.error("Rejecting RecordedEvent -- queue is full!!!");
        }
        return success;
    }

    public Stream<RecordedEvent> drainToStream() {
        ArrayList list = new ArrayList(this.queue.size());
        this.queue.drainTo(list);
        return list.stream();
    }

    public Instant start() {
        return this.ctx.getFirstEventTime();
    }

    public Instant end() {
        return this.ctx.getLastEventTime();
    }

    static class RawProcessingContext {
        private Instant firstEventTime = null;
        private Instant lastEventTime = null;
        private Instant lastSeen;

        public RawProcessingContext() {
            this(Instant.EPOCH);
        }

        public RawProcessingContext(Instant lastSeen) {
            this.lastSeen = lastSeen;
        }

        public void update(RecordedEvent event) {
            this.updateFirstEventTime(event);
            this.updateLastEventTime(event);
        }

        private void updateFirstEventTime(RecordedEvent event) {
            if (this.firstEventTime == null) {
                this.firstEventTime = event.getStartTime();
            }
        }

        private void updateLastEventTime(RecordedEvent event) {
            this.lastEventTime = event.getStartTime();
        }

        public Instant getFirstEventTime() {
            return this.firstEventTime;
        }

        public Instant getLastEventTime() {
            return this.lastEventTime;
        }

        public Instant getLastSeen() {
            return this.lastSeen;
        }

        public void resetForNewFile() {
            this.lastSeen = this.lastEventTime == null ? Instant.EPOCH : this.lastEventTime;
        }
    }
}

