/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import com.newrelic.jfr.daemon.DaemonConfig;
import com.newrelic.jfr.daemon.JFRUploader;
import com.newrelic.jfr.daemon.JfrController;
import com.newrelic.jfr.daemon.NewRelicTelemetrySender;
import com.newrelic.jfr.daemon.OkHttpPoster;
import com.newrelic.jfr.daemon.RecordedEventBuffer;
import com.newrelic.jfr.daemon.VersionFinder;
import com.newrelic.jfr.daemon.agent.FileJfrRecorderFactory;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.EventBatchSenderFactory;
import com.newrelic.telemetry.MetricBatchSenderFactory;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.TelemetryClient;
import com.newrelic.telemetry.events.EventBatchSender;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.jfr.consumer.RecordedEvent;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupUtils {
    private static final Logger logger = LoggerFactory.getLogger(SetupUtils.class);
    public static final String JFR_DAEMON = "JFR-Daemon/";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String HTTPS = "https";

    private SetupUtils() {
    }

    public static Attributes buildCommonAttributes(DaemonConfig config) {
        String hostname;
        Attributes attributes = new Attributes().put("instrumentation.name", "JFR").put("instrumentation.provider", "JFR-Uploader").put("collector.name", "JFR-Uploader");
        try {
            hostname = InetAddress.getLocalHost().toString();
        }
        catch (Throwable e) {
            hostname = InetAddress.getLoopbackAddress().toString();
        }
        attributes.put("host.hostname", hostname);
        attributes.put("app.name", config.getMonitoredAppName());
        attributes.put("service.name", config.getMonitoredAppName());
        return attributes;
    }

    public static DaemonConfig buildConfig() {
        String daemonVersion = VersionFinder.getVersion();
        DaemonConfig.Builder builder = DaemonConfig.builder().apiKey(System.getenv("INSIGHTS_INSERT_KEY")).daemonVersion(daemonVersion);
        builder.maybeEnv("NEW_RELIC_APP_NAME", Function.identity(), builder::monitoredAppName);
        builder.maybeEnv("REMOTE_JMX_HOST", Function.identity(), builder::jmxHost);
        builder.maybeEnv("REMOTE_JMX_PORT", Integer::parseInt, builder::jmxPort);
        builder.maybeEnv("METRICS_INGEST_URI", URI::create, builder::metricsUri);
        builder.maybeEnv("EVENTS_INGEST_URI", URI::create, builder::eventsUri);
        builder.maybeEnv("JFR_SHARED_FILESYSTEM", Boolean::parseBoolean, builder::useSharedFilesystem);
        builder.maybeEnv("USE_LICENSE_KEY", Boolean::parseBoolean, builder::useLicenseKey);
        builder.maybeEnv("AUDIT_LOGGING", Boolean::parseBoolean, builder::auditLogging);
        builder.maybeEnv("PROXY_HOST", Function.identity(), builder::proxyHost);
        builder.maybeEnv("PROXY_PORT", Integer::parseInt, builder::proxyPort);
        builder.maybeEnv("PROXY_USER", Function.identity(), builder::proxyUser);
        builder.maybeEnv("PROXY_PASSWORD", Function.identity(), builder::proxyPassword);
        builder.maybeEnv("PROXY_SCHEME", Function.identity(), builder::proxyScheme);
        builder.maybeEnv("THREAD_NAME_PATTERN", Function.identity(), builder::threadNamePattern);
        builder.maybeEnv("HARVEST_INTERVAL", Integer::parseInt, builder::harvestInterval);
        builder.maybeEnv("QUEUE_SIZE", Integer::parseInt, builder::queueSize);
        return builder.build();
    }

    public static DaemonConfig buildDynamicAttachConfig(String agentArgs) {
        String daemonVersion = VersionFinder.getVersion();
        DaemonConfig.Builder builder = DaemonConfig.builder().useLicenseKey(true).daemonVersion(daemonVersion);
        String[] args2 = agentArgs.split("|");
        if (args2.length == 4) {
            try {
                builder.apiKey(args2[0]);
                builder.monitoredAppName(args2[1]);
                builder.metricsUri(new URI(args2[2]));
                builder.eventsUri(new URI(args2[3]));
            }
            catch (URISyntaxException urix) {
                throw new RuntimeException("Bad URI in config", urix);
            }
        }
        if (args2.length != 2) {
            throw new RuntimeException("Wrong number of arguments to config: " + agentArgs);
        }
        builder.apiKey(args2[0]);
        builder.monitoredAppName(args2[1]);
        return builder.build();
    }

    public static JFRUploader buildUploader(DaemonConfig config) {
        TelemetryClient telemetryClient = SetupUtils.buildTelemetryClient(config);
        LinkedBlockingQueue<RecordedEvent> queue = new LinkedBlockingQueue<RecordedEvent>(config.getQueueSize());
        RecordedEventBuffer recordedEventBuffer = new RecordedEventBuffer(queue);
        return new JFRUploader(new NewRelicTelemetrySender(telemetryClient), recordedEventBuffer);
    }

    public static JfrController buildJfrController(DaemonConfig config, JFRUploader uploader) {
        FileJfrRecorderFactory recorderFactory = new FileJfrRecorderFactory(config.getHarvestInterval());
        return new JfrController(recorderFactory, uploader, config.getHarvestInterval());
    }

    private static TelemetryClient buildTelemetryClient(DaemonConfig config) {
        Supplier<HttpPoster> httpPosterCreator = () -> new OkHttpPoster(SetupUtils.buildProxy(config), SetupUtils.buildProxyAuthenticator(config), Duration.of(10L, ChronoUnit.SECONDS));
        MetricBatchSender metricBatchSender = SetupUtils.buildMetricBatchSender(config, httpPosterCreator);
        EventBatchSender eventBatchSender = SetupUtils.buildEventBatchSender(config, httpPosterCreator);
        return new TelemetryClient(metricBatchSender, null, eventBatchSender, null);
    }

    private static EventBatchSender buildEventBatchSender(DaemonConfig config, Supplier<HttpPoster> httpPosterCreator) {
        SenderConfiguration.SenderConfigurationBuilder eventsConfig = EventBatchSenderFactory.fromHttpImplementation(httpPosterCreator).configureWith(config.getApiKey()).auditLoggingEnabled(config.auditLogging()).secondaryUserAgent(SetupUtils.makeUserAgent(config)).useLicenseKey(config.useLicenseKey());
        if (config.getEventsUri() != null) {
            eventsConfig = eventsConfig.endpoint(SetupUtils.toURL(config.getEventsUri()));
        }
        if (config.useLicenseKey()) {
            eventsConfig = eventsConfig.useLicenseKey(true);
        }
        return EventBatchSender.create(eventsConfig.build());
    }

    private static MetricBatchSender buildMetricBatchSender(DaemonConfig config, Supplier<HttpPoster> httpPosterCreator) {
        SenderConfiguration.SenderConfigurationBuilder metricConfig = MetricBatchSenderFactory.fromHttpImplementation(httpPosterCreator).configureWith(config.getApiKey()).secondaryUserAgent(SetupUtils.makeUserAgent(config)).auditLoggingEnabled(config.auditLogging()).useLicenseKey(config.useLicenseKey());
        if (config.getMetricsUri() != null) {
            metricConfig = metricConfig.endpoint(SetupUtils.toURL(config.getMetricsUri()));
        }
        if (config.useLicenseKey()) {
            metricConfig = metricConfig.useLicenseKey(true);
        }
        return MetricBatchSender.create(metricConfig.build());
    }

    private static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not convert URI to URL.", e);
        }
    }

    private static String makeUserAgent(DaemonConfig config) {
        return JFR_DAEMON + config.getDaemonVersion();
    }

    private static Proxy buildProxy(DaemonConfig config) {
        String proxyHost = config.getProxyHost();
        Integer proxyPort = config.getProxyPort();
        String proxyScheme = config.getProxyScheme();
        if (proxyHost == null || proxyPort == null || proxyScheme == null) {
            return null;
        }
        if (proxyScheme.equalsIgnoreCase(HTTPS)) {
            logger.error("HTTPS proxy is not currently supported.");
            return null;
        }
        logger.info("JFR HttpPoster configured to use " + proxyScheme + " proxy: " + proxyHost + ":" + proxyPort);
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
    }

    private static Authenticator buildProxyAuthenticator(DaemonConfig config) {
        String proxyUser = config.getProxyUser();
        String proxyPassword = config.getProxyPassword();
        if (proxyUser == null || proxyPassword == null) {
            return null;
        }
        logger.info("JFR HttpPoster configured with proxy user and proxy password.");
        return (route, response) -> response.request().newBuilder().header(PROXY_AUTHORIZATION, Credentials.basic(proxyUser, proxyPassword)).build();
    }
}

