/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon.app;

import com.newrelic.jfr.daemon.SafeSleep;
import com.newrelic.telemetry.Backoff;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(MBeanConnectionFactory.class);
    private final String jmxHost;
    private final int jmxPort;

    public MBeanConnectionFactory(String jmxHost, int jmxPort) {
        this.jmxHost = jmxHost;
        this.jmxPort = jmxPort;
    }

    public MBeanServerConnection awaitConnection(Backoff backoff) throws IOException {
        String urlPath = String.format("/jndi/rmi://%s:%s/jmxrmi", this.jmxHost, this.jmxPort);
        JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
        while (true) {
            try {
                JMXConnector jmxConnector = this.connect(url);
                MBeanServerConnection connection = jmxConnector.getMBeanServerConnection();
                logger.info("Connection to remote MBean Sever complete.");
                return connection;
            }
            catch (IOException e) {
                long backoffMillis = backoff.nextWaitMs();
                if (backoffMillis == -1L) {
                    throw new IOException("Failed to connect to remote MBean Sever after completing backoff.", e);
                }
                logger.info("Error connecting to remote MBean Server. Backing off {} millis.", (Object)backoffMillis);
                SafeSleep.sleep(Duration.ofMillis(backoffMillis));
                continue;
            }
            break;
        }
    }

    public static Backoff waitForeverBackoff() {
        return Backoff.builder().maxBackoff(15, TimeUnit.SECONDS).backoffFactor(1, TimeUnit.SECONDS).maxRetries(Integer.MAX_VALUE).build();
    }

    JMXConnector connect(JMXServiceURL url) throws IOException {
        return JMXConnectorFactory.connect(url);
    }
}

