/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon.app;

import com.newrelic.jfr.daemon.SafeSleep;
import com.newrelic.jfr.daemon.app.MBeanConnectionFactory;
import com.newrelic.telemetry.Backoff;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteEntityBridge {
    private static final Logger logger = LoggerFactory.getLogger(RemoteEntityBridge.class);

    public CompletableFuture<Optional<String>> fetchRemoteEntityIdAsync(MBeanServerConnection connection) {
        return CompletableFuture.supplyAsync(() -> this.awaitRemoteEntityId(connection, MBeanConnectionFactory.waitForeverBackoff()));
    }

    Optional<String> awaitRemoteEntityId(MBeanServerConnection connection, Backoff backoff) {
        while (true) {
            Optional<String> optGuid;
            try {
                optGuid = this.getRemoteEntityGuid(connection);
            }
            catch (Exception e) {
                logger.info("Unable to identify remote agent. Not setting entity guid.");
                return Optional.empty();
            }
            if (optGuid.isPresent()) {
                logger.info("Obtained entity guid from remote agent: {}", (Object)optGuid.get());
                return optGuid;
            }
            long backoffMillis = backoff.nextWaitMs();
            if (backoffMillis == -1L) {
                logger.info("Remote agent identified but unable to obtain guid after backing off. Not setting entity guid.");
                return Optional.empty();
            }
            logger.info("Remote agent identified but entity guid not yet available. Backing off {} millis.", (Object)backoffMillis);
            SafeSleep.sleep(Duration.ofMillis(backoffMillis));
        }
    }

    Optional<String> getRemoteEntityGuid(MBeanServerConnection connection) throws MalformedObjectNameException {
        Map<String, String> metadata = this.getLinkingMetadata(connection);
        return Optional.ofNullable(metadata.get("entity.guid"));
    }

    public Optional<String> getRemoteEntityName(MBeanServerConnection connection) {
        Map<String, String> metadata;
        try {
            metadata = this.getLinkingMetadata(connection);
        }
        catch (Exception e) {
            logger.info("Unable to identify remote agent. Not setting entity name from agent.");
            return Optional.empty();
        }
        Optional<String> entityNameOptional = Optional.ofNullable(metadata.get("entity.name"));
        entityNameOptional.ifPresent(s -> logger.info("Obtained entity name from remote agent: {}", s));
        return entityNameOptional;
    }

    Map<String, String> getLinkingMetadata(MBeanServerConnection connection) throws MalformedObjectNameException {
        ObjectName name = new ObjectName("com.newrelic.jfr:type=LinkingMetadata");
        LinkingMetadataMBean linkingMetadataMBean = JMX.newMBeanProxy(connection, name, LinkingMetadataMBean.class);
        return linkingMetadataMBean.readLinkingMetadata();
    }

    public static interface LinkingMetadataMBean {
        public Map<String, String> readLinkingMetadata();
    }
}

