/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.profiler;

import com.google.gson.Gson;
import com.newrelic.jfr.profiler.FlameLevel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public class FlamegraphMarshaller {
    private static final String ROOT = "root";
    private StackFrame profile = new StackFrame("root");

    public List<FlameLevel> flatten(StackFrame root) {
        return this.addChildren(root, null, new AtomicInteger(0));
    }

    private List<FlameLevel> addChildren(StackFrame current, FlameLevel parent, AtomicInteger idGenerator) {
        if (current == null) {
            return Collections.emptyList();
        }
        String parentId = parent == null ? null : parent.getId();
        String id = String.valueOf(idGenerator.incrementAndGet());
        FlameLevel currentNewFlameLevel = new FlameLevel(current.getName(), current.getValue(), parentId, id);
        LinkedList<FlameLevel> flattenedResult = new LinkedList<FlameLevel>();
        flattenedResult.add(currentNewFlameLevel);
        if (current.getChildren() == null) {
            return flattenedResult;
        }
        for (StackFrame child : current.getChildren()) {
            flattenedResult.addAll(this.addChildren(child, currentNewFlameLevel, idGenerator));
        }
        return flattenedResult;
    }

    public void processEvent(Stack<String> stack, Integer size) {
        StackFrame frame;
        StackFrame stackFrame = frame = this.profile;
        stackFrame.value = stackFrame.value + size;
        while (!stack.empty()) {
            frame = frame.addFrame(stack.pop(), size);
        }
    }

    public StackFrame getStackFrame() {
        return this.profile;
    }

    public void writeOutput(BufferedWriter bufferedWriter) throws IOException {
        Gson gson = new Gson();
        gson.toJson((Object)this.profile, (Appendable)bufferedWriter);
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson(this.profile);
    }

    public static class StackFrame {
        private String name;
        private Integer value = 0;
        private List<StackFrame> children = null;
        private Map<String, StackFrame> childrenMap = new HashMap<String, StackFrame>();

        public StackFrame(String name) {
            this.name = name;
        }

        public StackFrame addFrame(String frameName, Integer size) {
            StackFrame frame;
            if (this.children == null) {
                this.children = new ArrayList<StackFrame>();
            }
            if ((frame = this.childrenMap.get(frameName)) == null) {
                frame = new StackFrame(frameName);
                this.childrenMap.put(frameName, frame);
                this.children.add(frame);
            }
            StackFrame stackFrame = frame;
            stackFrame.value = stackFrame.value + size;
            return frame;
        }

        public String getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public List<StackFrame> getChildren() {
            return this.children;
        }

        public String toString() {
            Gson gson = new Gson();
            return gson.toJson(this);
        }
    }
}

