/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import com.newrelic.api.agent.NewRelic;
import java.util.logging.Level;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.impl.SimpleLoggerFactory;
import org.slf4j.spi.LoggerFactoryBinder;

public class StaticLoggerBinder
implements LoggerFactoryBinder {
    private static final StaticLoggerBinder SINGLETON = new StaticLoggerBinder();
    private static final String LOGGER_NAME = "com.newrelic.jfr.logger";
    public static String REQUESTED_API_VERSION = "1.6.99";
    private static final String loggerFactoryClassStr = AgentLoggerFactory.class.getName();
    private final ILoggerFactory loggerFactory;

    public static StaticLoggerBinder getSingleton() {
        return SINGLETON;
    }

    private StaticLoggerBinder() {
        if (this.isNewRelicAgentApiPresent()) {
            com.newrelic.api.agent.Logger agentLogger = NewRelic.getAgent().getLogger();
            this.loggerFactory = new AgentLoggerFactory(new AgentLoggerAdapter(agentLogger));
        } else {
            this.loggerFactory = new SimpleLoggerFactory();
        }
    }

    @Override
    public ILoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public String getLoggerFactoryClassStr() {
        return loggerFactoryClassStr;
    }

    private boolean isNewRelicAgentApiPresent() {
        try {
            Class.forName("com.newrelic.api.agent.NewRelic");
            return true;
        }
        catch (ClassNotFoundException __) {
            return false;
        }
    }

    private static class AgentLoggerAdapter
    extends MarkerIgnoringBase {
        private final com.newrelic.api.agent.Logger logger;

        private AgentLoggerAdapter(com.newrelic.api.agent.Logger agentLogger) {
            this.logger = agentLogger;
        }

        @Override
        public String getName() {
            return StaticLoggerBinder.LOGGER_NAME;
        }

        public void formatAndLog(Level level, String format, Object ... arguments) {
            FormattingTuple tp = MessageFormatter.arrayFormat(format, arguments);
            Throwable throwable = tp.getThrowable();
            String message = tp.getMessage();
            if (throwable != null) {
                this.logger.log(level, throwable, message);
            } else {
                this.logger.log(level, message);
            }
        }

        @Override
        public boolean isTraceEnabled() {
            return true;
        }

        @Override
        public void trace(String s) {
            this.formatAndLog(Level.FINEST, s, new Object[0]);
        }

        @Override
        public void trace(String s, Object o) {
            this.formatAndLog(Level.FINEST, s, o);
        }

        @Override
        public void trace(String s, Object o, Object o1) {
            this.formatAndLog(Level.FINEST, s, o, o1);
        }

        @Override
        public void trace(String s, Object ... objects) {
            this.formatAndLog(Level.FINEST, s, objects);
        }

        @Override
        public void trace(String s, Throwable throwable) {
            this.formatAndLog(Level.FINEST, s, throwable);
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public void debug(String s) {
            this.formatAndLog(Level.FINEST, s, new Object[0]);
        }

        @Override
        public void debug(String s, Object o) {
            this.formatAndLog(Level.FINEST, s, o);
        }

        @Override
        public void debug(String s, Object o, Object o1) {
            this.formatAndLog(Level.FINEST, s, o, o1);
        }

        @Override
        public void debug(String s, Object ... objects) {
            this.formatAndLog(Level.FINEST, s, objects);
        }

        @Override
        public void debug(String s, Throwable throwable) {
            this.formatAndLog(Level.FINEST, s, throwable);
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public void info(String s) {
            this.formatAndLog(Level.INFO, s, new Object[0]);
        }

        @Override
        public void info(String s, Object o) {
            this.formatAndLog(Level.INFO, s, o);
        }

        @Override
        public void info(String s, Object o, Object o1) {
            this.formatAndLog(Level.INFO, s, o, o1);
        }

        @Override
        public void info(String s, Object ... objects) {
            this.formatAndLog(Level.INFO, s, objects);
        }

        @Override
        public void info(String s, Throwable throwable) {
            this.formatAndLog(Level.INFO, s, throwable);
        }

        @Override
        public boolean isWarnEnabled() {
            return true;
        }

        @Override
        public void warn(String s) {
            this.formatAndLog(Level.WARNING, s, new Object[0]);
        }

        @Override
        public void warn(String s, Object o) {
            this.formatAndLog(Level.WARNING, s, o);
        }

        @Override
        public void warn(String s, Object ... objects) {
            this.formatAndLog(Level.WARNING, s, objects);
        }

        @Override
        public void warn(String s, Object o, Object o1) {
            this.formatAndLog(Level.WARNING, s, o, o1);
        }

        @Override
        public void warn(String s, Throwable throwable) {
            this.formatAndLog(Level.WARNING, s, throwable);
        }

        @Override
        public boolean isErrorEnabled() {
            return true;
        }

        @Override
        public void error(String s) {
            this.formatAndLog(Level.SEVERE, s, new Object[0]);
        }

        @Override
        public void error(String s, Object o) {
            this.formatAndLog(Level.SEVERE, s, o);
        }

        @Override
        public void error(String s, Object o, Object o1) {
            this.formatAndLog(Level.SEVERE, s, o, o1);
        }

        @Override
        public void error(String s, Object ... objects) {
            this.formatAndLog(Level.SEVERE, s, objects);
        }

        @Override
        public void error(String s, Throwable throwable) {
            this.formatAndLog(Level.SEVERE, s, throwable);
        }
    }

    private static class AgentLoggerFactory
    implements ILoggerFactory {
        private final AgentLoggerAdapter agentLoggerAdapter;

        private AgentLoggerFactory(AgentLoggerAdapter agentLoggerAdapter) {
            this.agentLoggerAdapter = agentLoggerAdapter;
        }

        @Override
        public Logger getLogger(String name) {
            return this.agentLoggerAdapter;
        }
    }
}

