/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.newrelic.relocated.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedStackTrace;

public final class MethodSupport {
    private static final int JSON_SCHEMA_VERSION = 1;
    private static final int HEADROOM_75PC = 3072;

    public static String describeMethod(RecordedMethod method) {
        if (method == null) {
            return "[missing]";
        }
        return method.getType().getName() + "." + method.getName() + method.getDescriptor();
    }

    public static String serialize(RecordedStackTrace trace) {
        ArrayList<Map<String, String>> payload = new ArrayList<Map<String, String>>();
        List<RecordedFrame> frames = trace.getFrames();
        for (int i = 0; i < frames.size(); ++i) {
            HashMap<String, Object> frameData = new HashMap<String, Object>();
            RecordedFrame frame = frames.get(i);
            frameData.put("desc", MethodSupport.describeMethod(frame.getMethod()));
            frameData.put("line", "" + frame.getLineNumber());
            frameData.put("bytecodeIndex", "" + frame.getBytecodeIndex());
            payload.add(frameData);
        }
        try {
            return new String(MethodSupport.jsonWrite(payload, Optional.empty()).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate stacktrace json", e);
        }
    }

    static String jsonWrite(List<Map<String, String>> frames, Optional<Integer> limit) throws IOException {
        StringWriter strOut = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)strOut);
        int frameCount = Math.min(limit.orElse(frames.size()), frames.size());
        jsonWriter.beginObject();
        jsonWriter.name("type").value("stacktrace");
        jsonWriter.name("language").value("java");
        jsonWriter.name("version").value(1L);
        jsonWriter.name("truncated").value(frameCount < frames.size());
        jsonWriter.name("payload").beginArray();
        for (int i = 0; i < frameCount; ++i) {
            Map<String, String> frame = frames.get(i);
            jsonWriter.beginObject();
            jsonWriter.name("desc").value(frame.get("desc"));
            jsonWriter.name("line").value(frame.get("line"));
            jsonWriter.name("bytecodeIndex").value(frame.get("bytecodeIndex"));
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
        String out = strOut.toString();
        int length = out.length();
        if (length > 3072) {
            double percentageOfFramesToTry = 3072.0 / (double)length;
            int numFrames = (int)((double)frameCount * percentageOfFramesToTry);
            if (numFrames < frameCount) {
                return MethodSupport.jsonWrite(frames, Optional.of(numFrames));
            }
            throw new IOException("Corner case of a stack frame that can't be cleanly truncated! numFrames = " + numFrames + ", frameCount = " + frameCount + ", , percentageOfFramesToTry = " + percentageOfFramesToTry + ", length = " + length);
        }
        return out;
    }
}

