/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.newrelic.jfr.tometric.AllocationRequiringGCMapper;
import com.newrelic.jfr.tometric.CPUThreadLoadMapper;
import com.newrelic.jfr.tometric.ContextSwitchRateMapper;
import com.newrelic.jfr.tometric.EventToMetric;
import com.newrelic.jfr.tometric.GCHeapSummaryMapper;
import com.newrelic.jfr.tometric.GarbageCollectionMapper;
import com.newrelic.jfr.tometric.MetaspaceSummaryMapper;
import com.newrelic.jfr.tometric.OverallCPULoadMapper;
import com.newrelic.jfr.tometric.ThreadAllocationStatisticsMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ToMetricRegistry {
    private static final List<EventToMetric> ALL_MAPPERS = List.of(new AllocationRequiringGCMapper(), new ContextSwitchRateMapper(), new CPUThreadLoadMapper(), new GarbageCollectionMapper(), new GCHeapSummaryMapper(), new MetaspaceSummaryMapper(), new OverallCPULoadMapper(), new ThreadAllocationStatisticsMapper());
    private final List<EventToMetric> mappers;

    private ToMetricRegistry(List<EventToMetric> mappers) {
        this.mappers = new ArrayList<EventToMetric>(mappers);
    }

    public static ToMetricRegistry createDefault() {
        return ToMetricRegistry.create(ToMetricRegistry.allEventNames());
    }

    public static ToMetricRegistry create(Collection<String> eventNames) {
        List<EventToMetric> filtered = ALL_MAPPERS.stream().filter(mapper -> eventNames.contains(mapper.getEventName())).collect(Collectors.toList());
        return new ToMetricRegistry(filtered);
    }

    private static List<String> allEventNames() {
        return ALL_MAPPERS.stream().map(EventToMetric::getEventName).collect(Collectors.toUnmodifiableList());
    }

    public Stream<EventToMetric> all() {
        return this.mappers.stream();
    }

    public Optional<EventToMetric> get(String eventName) {
        return this.mappers.stream().filter(toMetric -> toMetric.getEventName().equals(eventName)).findFirst();
    }
}

