/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.jfr.MethodSupport;
import com.newrelic.jfr.Workarounds;
import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.time.Duration;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedMethod;

public class JITCompilationMapper
implements EventToEvent {
    public static final String EVENT_NAME = "jdk.Compilation";

    @Override
    public List<Event> apply(RecordedEvent event) {
        long timestamp = event.getStartTime().toEpochMilli();
        Duration duration = event.getDuration();
        Attributes attr = new Attributes();
        attr.put("desc", MethodSupport.describeMethod((RecordedMethod)event.getValue("method")));
        attr.put("thread.name", event.getThread("eventThread").getJavaName());
        attr.put("duration", (Number)duration.toMillis());
        attr.put("succeeded", Workarounds.getSucceeded(event));
        return List.of(new Event("JfrCompilation", attr, timestamp));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }
}

