/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;

public class JVMInformationMapper
implements EventToEvent {
    public static final String EVENT_NAME = "jdk.JVMInformation";

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public List<Event> apply(RecordedEvent event) {
        long timestamp = event.getStartTime().toEpochMilli();
        Attributes attr = new Attributes();
        attr.put("jvmArguments", event.getString("jvmArguments"));
        attr.put("jvmStartTime", (Number)event.getInstant("jvmStartTime").toEpochMilli());
        attr.put("jvmVersion", event.getString("jvmVersion"));
        return List.of(new Event("JfrJVMInformation", attr, timestamp));
    }
}

