/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.jfr.MethodSupport;
import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedStackTrace;

public class MethodSampleMapper
implements EventToEvent {
    public static final String EVENT_NAME = "jdk.ExecutionSample";
    public static final String NATIVE_EVENT_NAME = "jdk.NativeMethodSample";
    private final String eventName;

    private MethodSampleMapper(String eventName) {
        this.eventName = eventName;
    }

    public static MethodSampleMapper forExecutionSample() {
        return new MethodSampleMapper(EVENT_NAME);
    }

    public static MethodSampleMapper forNativeMethodSample() {
        return new MethodSampleMapper(NATIVE_EVENT_NAME);
    }

    @Override
    public List<Event> apply(RecordedEvent ev) {
        RecordedStackTrace trace = ev.getStackTrace();
        if (trace == null) {
            return List.of();
        }
        long timestamp = ev.getStartTime().toEpochMilli();
        Attributes attr = new Attributes();
        attr.put("thread.name", ev.getThread("sampledThread").getJavaName());
        attr.put("thread.state", ev.getString("state"));
        attr.put("stackTrace", MethodSupport.serialize(ev.getStackTrace()));
        return List.of(new Event("JfrMethodSample", attr, timestamp));
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }
}

