/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import jdk.jfr.consumer.RecordedEvent;

public class ThreadLockEventMapper
implements EventToEvent {
    public static final String EVENT_NAME = "jdk.JavaMonitorWait";

    @Override
    public List<Event> apply(RecordedEvent ev) {
        Duration duration = ev.getDuration();
        if (duration.toMillis() > 20L) {
            long timestamp = ev.getStartTime().toEpochMilli();
            Attributes attr = new Attributes();
            attr.put("thread.name", ev.getThread("eventThread").getJavaName());
            attr.put("class", ev.getClass("monitorClass").getName());
            attr.put("duration", (Number)duration.toMillis());
            return List.of(new Event("JfrJavaMonitorWait", attr, timestamp));
        }
        return List.of();
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.of(1L, TimeUnit.SECONDS.toChronoUnit()));
    }
}

