/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tometric;

import com.newrelic.jfr.Workarounds;
import com.newrelic.jfr.tometric.EventToMetric;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import jdk.jfr.consumer.RecordedEvent;

public class CPUThreadLoadMapper
implements EventToMetric {
    public static final String EVENT_NAME = "jdk.ThreadCPULoad";

    @Override
    public List<? extends Metric> apply(RecordedEvent ev) {
        Optional<String> possibleThreadName = Workarounds.getThreadName(ev);
        if (possibleThreadName.isPresent()) {
            String threadName = possibleThreadName.get();
            long timestamp = ev.getStartTime().toEpochMilli();
            Attributes attr = new Attributes().put("thread.name", threadName);
            return List.of(new Gauge("jfr.ThreadCPULoad.user", ev.getDouble("user"), timestamp, attr), new Gauge("jfr.ThreadCPULoad.system", ev.getDouble("system"), timestamp, attr));
        }
        return List.of();
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.of(1L, TimeUnit.SECONDS.toChronoUnit()));
    }
}

