/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tometric;

import com.newrelic.jfr.tometric.EventToMetric;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import jdk.jfr.consumer.RecordedEvent;

public class ContextSwitchRateMapper
implements EventToMetric {
    public static final String EVENT_NAME = "jdk.ThreadContextSwitchRate";

    @Override
    public List<? extends Metric> apply(RecordedEvent ev) {
        long timestamp = ev.getStartTime().toEpochMilli();
        Attributes attr = new Attributes();
        return List.of(new Gauge("jfr.ThreadContextSwitchRate", ev.getDouble("switchRate"), timestamp, attr));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.of(1L, TimeUnit.SECONDS.toChronoUnit()));
    }
}

