/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tometric;

import com.newrelic.jfr.tometric.EventToMetric;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedObject;

public class GCHeapSummaryMapper
implements EventToMetric {
    public static final String EVENT_NAME = "jdk.GCHeapSummary";

    @Override
    public List<? extends Metric> apply(RecordedEvent ev) {
        long timestamp = ev.getStartTime().toEpochMilli();
        long heapUsed = ev.getLong("heapUsed");
        RecordedObject heapSpace = (RecordedObject)ev.getValue("heapSpace");
        long committedSize = heapSpace.getLong("committedSize");
        long reservedSize = heapSpace.getLong("reservedSize");
        Attributes attr = new Attributes().put("when", ev.getString("when")).put("heapStart", (Number)heapSpace.getLong("start")).put("committedEnd", (Number)heapSpace.getLong("committedEnd")).put("reservedEnd", (Number)heapSpace.getLong("reservedEnd"));
        return List.of(new Gauge("jfr.GCHeapSummary.heapUsed", (double)heapUsed, timestamp, attr), new Gauge("jfr.GCHeapSummary.heapCommittedSize", (double)committedSize, timestamp, attr), new Gauge("jfr.GCHeapSummary.reservedSize", (double)reservedSize, timestamp, attr));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }
}

