/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tometric;

import com.newrelic.jfr.tometric.EventToMetric;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedThread;

public class ThreadAllocationStatisticsMapper
implements EventToMetric {
    public static final String EVENT_NAME = "jdk.ThreadAllocationStatistics";

    @Override
    public List<? extends Metric> apply(RecordedEvent ev) {
        long time = ev.getStartTime().toEpochMilli();
        double allocated = ev.getDouble("allocated");
        RecordedThread t = (RecordedThread)ev.getValue("thread");
        Attributes attr = new Attributes();
        if (t != null) {
            attr.put("thread.name", t.getJavaName()).put("thread.osName", t.getOSName());
        }
        return List.of(new Gauge("jfr.ThreadAllocationStatistics.allocated", allocated, time, attr));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }
}

