/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import jdk.jfr.consumer.RecordedEvent;

public class DurationSummarizer {
    public static final Supplier<Long> DEFAULT_CLOCK = () -> Instant.now().toEpochMilli();
    private final Supplier<Long> clock;
    private final Optional<String> durationName;
    private long startTimeMs;
    private long endTimeMs;
    private Duration duration = Duration.ofNanos(0L);
    private Duration minDuration = Duration.ofNanos(Long.MAX_VALUE);
    private Duration maxDuration = Duration.ofNanos(Long.MIN_VALUE);

    public DurationSummarizer(long startTimeMs) {
        this(startTimeMs, DEFAULT_CLOCK);
    }

    public DurationSummarizer(long startTimeMs, Supplier<Long> clock) {
        this(startTimeMs, clock, null);
    }

    public DurationSummarizer(long startTimeMs, Supplier<Long> clock, String durationName) {
        this.endTimeMs = this.startTimeMs = startTimeMs;
        this.clock = clock;
        this.durationName = Optional.ofNullable(durationName);
    }

    public void accept(RecordedEvent ev) {
        Duration duration = this.getDuration(ev);
        this.endTimeMs = ev.getStartTime().plus(duration).toEpochMilli();
        this.duration = this.duration.plus(duration);
        if (duration.compareTo(this.maxDuration) > 0) {
            this.maxDuration = duration;
        }
        if (duration.compareTo(this.minDuration) < 0) {
            this.minDuration = duration;
        }
    }

    private Duration getDuration(RecordedEvent ev) {
        return this.durationName.map(ev::getDuration).orElse(ev.getDuration());
    }

    public void reset() {
        this.startTimeMs = this.clock.get();
        this.endTimeMs = 0L;
        this.duration = Duration.ofNanos(0L);
        this.minDuration = Duration.ofNanos(Long.MAX_VALUE);
        this.maxDuration = Duration.ofNanos(Long.MIN_VALUE);
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getEndTimeMs() {
        return this.endTimeMs;
    }

    public double getDurationMillis() {
        return this.duration.toMillis();
    }

    public double getMinDurationMillis() {
        return this.minDuration.toMillis();
    }

    public double getMaxDurationMillis() {
        return this.maxDuration.toMillis();
    }
}

