/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.tosummary.DurationSummarizer;
import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Summary;
import java.time.Instant;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public final class G1GarbageCollectionSummarizer
implements EventToSummary {
    public static final String EVENT_NAME = "jdk.G1GarbageCollection";
    private final DurationSummarizer summarizer;
    private int count = 0;
    private long startTimeMs;
    private long endTimeMs = 0L;

    public G1GarbageCollectionSummarizer() {
        this(Instant.now().toEpochMilli());
    }

    public G1GarbageCollectionSummarizer(long startTimeMs) {
        this(startTimeMs, new DurationSummarizer(startTimeMs, DurationSummarizer.DEFAULT_CLOCK, "duration"));
    }

    public G1GarbageCollectionSummarizer(long startTimeMs, DurationSummarizer summarizer) {
        this.startTimeMs = startTimeMs;
        this.summarizer = summarizer;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.endTimeMs = ev.getStartTime().toEpochMilli();
        ++this.count;
        this.summarizer.accept(ev);
    }

    @Override
    public Stream<Summary> summarize() {
        Attributes attr = new Attributes();
        Summary out = new Summary("jfr.G1GarbageCollection.duration", this.count, this.summarizer.getDurationMillis(), this.summarizer.getMinDurationMillis(), this.summarizer.getMaxDurationMillis(), this.startTimeMs, this.endTimeMs, attr);
        return Stream.of(out);
    }

    @Override
    public void reset() {
        this.startTimeMs = Instant.now().toEpochMilli();
        this.endTimeMs = 0L;
        this.count = 0;
        this.summarizer.reset();
    }
}

