/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import jdk.jfr.consumer.RecordedEvent;

public class LongSummarizer {
    private final String fieldName;
    private int count = 0;
    private long sum = 0L;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    public LongSummarizer(String fieldName) {
        this.fieldName = fieldName;
    }

    public void accept(RecordedEvent ev) {
        ++this.count;
        long currentValue = ev.getLong(this.fieldName);
        this.sum += currentValue;
        if (currentValue > this.max) {
            this.max = currentValue;
        }
        if (currentValue < this.min) {
            this.min = currentValue;
        }
    }

    public void reset() {
        this.count = 0;
        this.sum = 0L;
        this.min = Long.MAX_VALUE;
        this.max = 0L;
    }

    public int getCount() {
        return this.count;
    }

    public long getSum() {
        return this.sum;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }
}

