/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.Workarounds;
import com.newrelic.jfr.tosummary.AbstractThreadDispatchingSummarizer;
import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.PerThreadNetworkReadSummarizer;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public class NetworkReadSummarizer
extends AbstractThreadDispatchingSummarizer {
    public static final String EVENT_NAME = "jdk.SocketRead";

    @Override
    public void accept(RecordedEvent ev) {
        Optional<String> possibleThreadName = Workarounds.getThreadName(ev);
        possibleThreadName.ifPresent(threadName -> {
            if (this.perThread.get(threadName) == null) {
                this.perThread.put(threadName, new PerThreadNetworkReadSummarizer((String)threadName, ev.getStartTime().toEpochMilli()));
            }
            ((EventToSummary)this.perThread.get(threadName)).accept(ev);
        });
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }
}

