/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.tosummary.DurationSummarizer;
import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.LongSummarizer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Summary;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public class PerThreadNetworkReadSummarizer
implements EventToSummary {
    private final String threadName;
    private final LongSummarizer bytesSummary;
    private final DurationSummarizer duration;

    public PerThreadNetworkReadSummarizer(String threadName, long startTimeMs) {
        this(threadName, new LongSummarizer("bytesRead"), new DurationSummarizer(startTimeMs));
    }

    public PerThreadNetworkReadSummarizer(String threadName, LongSummarizer longSummarizer, DurationSummarizer duration) {
        this.threadName = threadName;
        this.bytesSummary = longSummarizer;
        this.duration = duration;
    }

    @Override
    public String getEventName() {
        return "jdk.SocketRead";
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.bytesSummary.accept(ev);
        this.duration.accept(ev);
    }

    @Override
    public Stream<Summary> summarize() {
        Attributes attr = new Attributes().put("thread.name", this.threadName);
        Summary outRead = new Summary("jfr.SocketRead.bytesRead", this.bytesSummary.getCount(), (double)this.bytesSummary.getSum(), (double)this.bytesSummary.getMin(), (double)this.bytesSummary.getMax(), this.duration.getStartTimeMs(), this.duration.getEndTimeMs(), attr);
        Summary outDuration = new Summary("jfr.SocketRead.duration", this.bytesSummary.getCount(), this.duration.getDurationMillis(), this.duration.getMinDurationMillis(), this.duration.getMaxDurationMillis(), this.duration.getStartTimeMs(), outRead.getEndTimeMs(), attr);
        return Stream.of(outRead, outDuration);
    }

    @Override
    public void reset() {
        this.bytesSummary.reset();
        this.duration.reset();
    }
}

