/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.LongSummarizer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Summary;
import java.time.Instant;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public final class PerThreadObjectAllocationInNewTLABSummarizer
implements EventToSummary {
    private final String threadName;
    private final LongSummarizer summarizer;
    private long startTimeMs;
    private long endTimeMs = 0L;

    public PerThreadObjectAllocationInNewTLABSummarizer(String threadName, long startTimeMs) {
        this(threadName, startTimeMs, new LongSummarizer("tlabSize"));
    }

    public PerThreadObjectAllocationInNewTLABSummarizer(String threadName, long startTimeMs, LongSummarizer summarizer) {
        this.threadName = threadName;
        this.startTimeMs = startTimeMs;
        this.summarizer = summarizer;
    }

    @Override
    public String getEventName() {
        return "jdk.ObjectAllocationInNewTLAB";
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.endTimeMs = ev.getStartTime().toEpochMilli();
        this.summarizer.accept(ev);
    }

    @Override
    public Stream<Summary> summarize() {
        Attributes attr = new Attributes().put("thread.name", this.threadName);
        Summary out = new Summary("jfr.ObjectAllocationInNewTLAB.allocation", this.summarizer.getCount(), (double)this.summarizer.getSum(), (double)this.summarizer.getMin(), (double)this.summarizer.getMax(), this.startTimeMs, this.endTimeMs, attr);
        return Stream.of(out);
    }

    @Override
    public void reset() {
        this.startTimeMs = Instant.now().toEpochMilli();
        this.endTimeMs = 0L;
        this.summarizer.reset();
    }
}

