/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.labs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.newrelic.labs.LogEntry;
import com.newrelic.labs.LowercaseKeyMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.zip.GZIPOutputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LogForwarder {
    private final BlockingQueue<LogEntry> logQueue;
    private final String apiKey;
    private final String apiURL;
    private final OkHttpClient client = new OkHttpClient();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final long maxMessageSize;

    public LogForwarder(String apiKey, String apiURL, long maxMessageSize, BlockingQueue<LogEntry> logQueue) {
        this.apiKey = apiKey;
        this.apiURL = apiURL;
        this.maxMessageSize = maxMessageSize;
        this.logQueue = logQueue;
    }

    public boolean isInitialized() {
        return this.apiKey != null && this.apiURL != null;
    }

    public void flush(List<LogEntry> logEntries) {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String hostname = localhost != null ? localhost.getHostName() : "unknown";
        try {
            ArrayList<Map<String, Object>> logEvents = new ArrayList<Map<String, Object>>();
            for (LogEntry entry : logEntries) {
                Map logEvent = (Map)this.objectMapper.convertValue((Object)entry, LowercaseKeyMap.class);
                logEvent.put("hostname", hostname);
                logEvent.put("logtype", entry.getLogType());
                logEvent.put("timestamp", entry.getTimestamp());
                logEvent.put("applicationName", entry.getApplicationName());
                logEvent.put("name", entry.getName());
                logEvent.put("source", "NRBatchingAppender");
                if (entry.getcustom() != null) {
                    logEvent.put("custom", entry.getcustom());
                }
                logEvents.add(logEvent);
            }
            String jsonPayload = this.objectMapper.writeValueAsString(logEvents);
            byte[] compressedPayload = this.gzipCompress(jsonPayload);
            if ((long)compressedPayload.length > this.maxMessageSize) {
                this.splitAndSendLogs(logEntries);
            } else {
                this.sendLogs(logEvents);
            }
        }
        catch (IOException e) {
            System.err.println("Error during log forwarding: " + e.getMessage());
        }
    }

    private void splitAndSendLogs(List<LogEntry> logEntries) throws IOException {
        ArrayList<LogEntry> subBatch = new ArrayList<LogEntry>();
        int currentSize = 0;
        for (LogEntry entry : logEntries) {
            String entryJson = this.objectMapper.writeValueAsString((Object)entry);
            int entrySize = this.gzipCompress(entryJson).length;
            if ((long)(currentSize + entrySize) > this.maxMessageSize) {
                this.sendLogs(this.convertToLogEvents(subBatch));
                subBatch.clear();
                currentSize = 0;
            }
            subBatch.add(entry);
            currentSize += entrySize;
        }
        if (!subBatch.isEmpty()) {
            this.sendLogs(this.convertToLogEvents(subBatch));
        }
    }

    private List<Map<String, Object>> convertToLogEvents(List<LogEntry> logEntries) {
        ArrayList<Map<String, Object>> logEvents = new ArrayList<Map<String, Object>>();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            String hostname = localhost.getHostName();
            for (LogEntry entry : logEntries) {
                Map logEvent = (Map)this.objectMapper.convertValue((Object)entry, LowercaseKeyMap.class);
                logEvent.put("hostname", hostname);
                logEvent.put("logtype", entry.getLogType());
                logEvent.put("timestamp", entry.getTimestamp());
                logEvent.put("applicationName", entry.getApplicationName());
                logEvent.put("name", entry.getName());
                logEvent.put("source", "NRBatchingAppender");
                if (entry.getcustom() != null) {
                    logEvent.put("custom", entry.getcustom());
                }
                logEvents.add(logEvent);
            }
        }
        catch (UnknownHostException e) {
            System.err.println("Error resolving local host: " + e.getMessage());
        }
        return logEvents;
    }

    private void sendLogs(List<Map<String, Object>> logEvents) throws IOException {
        String jsonPayload = this.objectMapper.writeValueAsString(logEvents);
        byte[] compressedPayload = this.gzipCompress(jsonPayload);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((byte[])compressedPayload, (MediaType)mediaType);
        Request request = new Request.Builder().url(this.apiURL).post(requestBody).addHeader("X-License-Key", this.apiKey).addHeader("Content-Type", "application/json").addHeader("Content-Encoding", "gzip").build();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Response response = this.client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    System.err.println("Failed to send logs to New Relic: " + response.code() + " - " + response.message());
                    System.err.println("Response body: " + response.body().string());
                    this.requeueLogs(logEvents);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Error during log forwarding: " + e.getMessage());
            this.requeueLogs(logEvents);
        }
    }

    private void requeueLogs(List<Map<String, Object>> logEvents) {
        for (Map<String, Object> logEvent : logEvents) {
            try {
                LogEntry logEntry = (LogEntry)this.objectMapper.convertValue(logEvent, LogEntry.class);
                this.logQueue.put(logEntry);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.println("Failed to requeue log entry: " + logEvent);
            }
        }
    }

    private byte[] gzipCompress(String input) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (GZIPOutputStream gzipOS = new GZIPOutputStream(bos);){
            gzipOS.write(input.getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return bos.toByteArray();
    }

    public void close() {
        ArrayList<LogEntry> remainingLogs = new ArrayList<LogEntry>();
        this.logQueue.drainTo(remainingLogs);
        if (!remainingLogs.isEmpty()) {
            System.out.println("Flushing remaining " + remainingLogs.size() + " log events to New Relic...");
            this.flush(remainingLogs);
        }
    }
}

