/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.labs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.newrelic.labs.LogEntry;
import com.newrelic.labs.LowercaseKeyMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LogForwarder {
    private final BlockingQueue<LogEntry> logQueue;
    private final String apiKey;
    private final String apiURL;
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;
    private final long maxMessageSize;
    private final int maxRetries;
    private final long timeout;

    public LogForwarder(String apiKey, String apiURL, long maxMessageSize, BlockingQueue<LogEntry> logQueue, int maxRetries, long timeout) {
        this.apiKey = apiKey;
        this.apiURL = apiURL;
        this.maxMessageSize = maxMessageSize;
        this.logQueue = logQueue;
        this.maxRetries = maxRetries;
        this.timeout = timeout;
        this.client = new OkHttpClient.Builder().connectTimeout(timeout, TimeUnit.MILLISECONDS).build();
        this.objectMapper = new ObjectMapper();
    }

    public boolean isInitialized() {
        return this.apiKey != null && this.apiURL != null;
    }

    public boolean flush(List<LogEntry> logEntries, boolean mergeCustomFields, Map<String, Object> customFields) {
        InetAddress localhost = null;
        boolean bStatus = false;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String hostname = localhost != null ? localhost.getHostName() : "unknown";
        try {
            ArrayList<Map<String, Object>> logEvents = new ArrayList<Map<String, Object>>();
            for (LogEntry entry : logEntries) {
                Map logEvent = (Map)this.objectMapper.convertValue((Object)entry, LowercaseKeyMap.class);
                logEvent.put("hostname", hostname);
                logEvent.put("logtype", entry.getLogType());
                logEvent.put("timestamp", entry.getTimestamp());
                logEvent.put("applicationName", entry.getApplicationName());
                logEvent.put("name", entry.getName());
                logEvent.put("source", "NRBatchingAppender");
                if (customFields != null) {
                    if (mergeCustomFields) {
                        Map<String, Object> customFields1 = customFields;
                        for (Map.Entry<String, Object> field : customFields1.entrySet()) {
                            logEvent.put(field.getKey(), field.getValue());
                        }
                    } else {
                        logEvent.put("custom", customFields);
                    }
                }
                logEvents.add(logEvent);
            }
            String jsonPayload = this.objectMapper.writeValueAsString(logEvents);
            byte[] compressedPayload = this.gzipCompress(jsonPayload);
            bStatus = (long)compressedPayload.length > this.maxMessageSize ? this.splitAndSendLogs(logEntries, mergeCustomFields, customFields) : this.sendLogs(logEvents);
        }
        catch (IOException e) {
            System.err.println("Error during log forwarding: " + e.getMessage());
            bStatus = false;
        }
        return bStatus;
    }

    private boolean splitAndSendLogs(List<LogEntry> logEntries, boolean mergeCustomFields, Map<String, Object> customFields) throws IOException {
        ArrayList<LogEntry> subBatch = new ArrayList<LogEntry>();
        int currentSize = 0;
        boolean bStatus = false;
        for (LogEntry entry : logEntries) {
            String entryJson;
            int entrySize;
            Map logEvent = (Map)this.objectMapper.convertValue((Object)entry, LowercaseKeyMap.class);
            logEvent.put("hostname", InetAddress.getLocalHost().getHostName());
            logEvent.put("logtype", entry.getLogType());
            logEvent.put("timestamp", entry.getTimestamp());
            logEvent.put("applicationName", entry.getApplicationName());
            logEvent.put("name", entry.getName());
            logEvent.put("source", "NRBatchingAppender");
            if (customFields != null) {
                if (mergeCustomFields) {
                    Map<String, Object> customFields1 = customFields;
                    for (Map.Entry<String, Object> field : customFields1.entrySet()) {
                        logEvent.put(field.getKey(), field.getValue());
                    }
                } else {
                    logEvent.put("custom", customFields);
                }
            }
            if ((long)(currentSize + (entrySize = this.gzipCompress(entryJson = this.objectMapper.writeValueAsString((Object)logEvent)).length)) > this.maxMessageSize) {
                bStatus = this.sendLogs(this.convertToLogEvents(subBatch, mergeCustomFields, customFields));
                subBatch.clear();
                currentSize = 0;
            }
            subBatch.add(entry);
            currentSize += entrySize;
        }
        if (!subBatch.isEmpty()) {
            bStatus = this.sendLogs(this.convertToLogEvents(subBatch, mergeCustomFields, customFields));
        }
        return bStatus;
    }

    private List<Map<String, Object>> convertToLogEvents(List<LogEntry> logEntries, boolean mergeCustomFields, Map<String, Object> customFields) {
        ArrayList<Map<String, Object>> logEvents = new ArrayList<Map<String, Object>>();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            String hostname = localhost.getHostName();
            for (LogEntry entry : logEntries) {
                Map logEvent = (Map)this.objectMapper.convertValue((Object)entry, LowercaseKeyMap.class);
                logEvent.put("hostname", hostname);
                logEvent.put("logtype", entry.getLogType());
                logEvent.put("timestamp", entry.getTimestamp());
                logEvent.put("applicationName", entry.getApplicationName());
                logEvent.put("name", entry.getName());
                logEvent.put("source", "NRBatchingAppender");
                if (customFields != null) {
                    if (mergeCustomFields) {
                        Map<String, Object> customFields1 = customFields;
                        for (Map.Entry<String, Object> field : customFields1.entrySet()) {
                            logEvent.put(field.getKey(), field.getValue());
                        }
                    } else {
                        logEvent.put("custom", customFields);
                    }
                }
                logEvents.add(logEvent);
            }
        }
        catch (UnknownHostException e) {
            System.err.println("Error resolving local host: " + e.getMessage());
        }
        return logEvents;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendLogs(List<Map<String, Object>> logEvents) throws IOException {
        String jsonPayload = this.objectMapper.writeValueAsString(logEvents);
        byte[] compressedPayload = this.gzipCompress(jsonPayload);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((byte[])compressedPayload, (MediaType)mediaType);
        Request request = new Request.Builder().url(this.apiURL).post(requestBody).addHeader("X-License-Key", this.apiKey).addHeader("Content-Type", "application/json").addHeader("Content-Encoding", "gzip").build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) return true;
            System.err.println("Failed to send logs to New Relic: " + response.code() + " - " + response.message());
            System.err.println("Response body: " + response.body().string());
            this.requeueLogs(logEvents);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            System.err.println("Error during log forwarding: " + e.getMessage());
            this.requeueLogs(logEvents);
            return false;
        }
    }

    private void requeueLogs(List<Map<String, Object>> logEvents) {
        for (Map<String, Object> logEvent : logEvents) {
            try {
                LogEntry logEntry = (LogEntry)this.objectMapper.convertValue(logEvent, LogEntry.class);
                this.logQueue.put(logEntry);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.println("Failed to requeue log entry: " + logEvent);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to convert log event to LogEntry: " + logEvent);
            }
        }
        System.err.println("Network issue - NewRelicBatchingAppenderhas re-queued " + logEvents.size() + " entries : queue size " + this.logQueue.size());
    }

    private byte[] gzipCompress(String input) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOS = new GZIPOutputStream(bos);){
            gzipOS.write(input.getBytes());
        }
        return bos.toByteArray();
    }

    public void close(boolean mergeCustomFields, Map<String, Object> customFields) {
        ArrayList<LogEntry> remainingLogs = new ArrayList<LogEntry>();
        this.logQueue.drainTo(remainingLogs);
        if (!remainingLogs.isEmpty()) {
            System.out.println("Flushing remaining " + remainingLogs.size() + " log events to New Relic...");
            this.flush(remainingLogs, mergeCustomFields, customFields);
        }
    }
}

