/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.labs;

import com.newrelic.labs.LogEntry;
import com.newrelic.labs.LogForwarder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="NewRelicBatchingAppender", category="Core", elementType="appender", printObject=true)
public class NewRelicBatchingAppender
extends AbstractAppender {
    private final BlockingQueue<LogEntry> queue = new LinkedBlockingQueue<LogEntry>();
    private final String apiKey;
    private final String apiUrl;
    private final String applicationName;
    private final String logType;
    private final boolean mergeCustomFields;
    private final String name;
    private final LogForwarder logForwarder;
    private static final Logger logger = StatusLogger.getLogger();
    private int attempt = 0;
    private final int batchSize;
    private final long maxMessageSize;
    private final long flushInterval;
    private final Map<String, Object> customFields;
    private final int maxRetries;
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private static final long DEFAULT_MAX_MESSAGE_SIZE = 0x100000L;
    private static final long DEFAULT_FLUSH_INTERVAL = 120000L;
    private static final String LOG_TYPE = "muleLog";
    private static final boolean MERGE_CUSTOM_FIELDS = false;

    protected NewRelicBatchingAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String apiKey, String apiUrl, String applicationName, Integer batchSize, Long maxMessageSize, Long flushInterval, String logType, String customFields, Boolean mergeCustomFields, int maxRetries, long timeout) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.apiKey = apiKey;
        this.apiUrl = apiUrl;
        this.applicationName = applicationName;
        this.name = name;
        this.maxRetries = maxRetries;
        this.batchSize = batchSize != null ? batchSize : 5000;
        this.maxMessageSize = maxMessageSize != null ? maxMessageSize : 0x100000L;
        this.flushInterval = flushInterval != null ? flushInterval : 120000L;
        this.logType = logType != null && logType.length() > 0 ? logType : LOG_TYPE;
        this.customFields = this.parsecustomFields(customFields);
        this.mergeCustomFields = mergeCustomFields != null ? mergeCustomFields : false;
        this.logForwarder = new LogForwarder(apiKey, apiUrl, this.maxMessageSize, this.queue, maxRetries, timeout);
        this.startFlushingTask();
    }

    private Map<String, Object> parsecustomFields(String customFields) {
        HashMap<String, Object> custom = new HashMap<String, Object>();
        if (customFields != null && !customFields.isEmpty()) {
            String[] pairs;
            for (String pair : pairs = customFields.split(",")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length != 2) continue;
                custom.put(keyValue[0], keyValue[1]);
            }
        }
        return custom;
    }

    @PluginFactory
    public static NewRelicBatchingAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="apiKey") String apiKey, @PluginAttribute(value="apiUrl") String apiUrl, @PluginAttribute(value="applicationName") String applicationName, @PluginAttribute(value="batchSize") Integer batchSize, @PluginAttribute(value="maxMessageSize") Long maxMessageSize, @PluginAttribute(value="logType") String logType, @PluginAttribute(value="flushInterval") Long flushInterval, @PluginAttribute(value="customFields") String customFields, @PluginAttribute(value="mergeCustomFields") Boolean mergeCustomFields, @PluginAttribute(value="maxRetries") Integer maxRetries, @PluginAttribute(value="timeout") Long timeout) {
        if (name == null) {
            logger.error("No name provided for NewRelicBatchingAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (apiKey == null || apiUrl == null || applicationName == null) {
            logger.error("API key, API URL, and application name must be provided for NewRelicBatchingAppender");
            return null;
        }
        int retries = maxRetries != null ? maxRetries : 3;
        long connectionTimeout = timeout != null ? timeout : 30000L;
        return new NewRelicBatchingAppender(name, filter, (Layout<? extends Serializable>)layout, true, apiKey, apiUrl, applicationName, batchSize, maxMessageSize, flushInterval, logType, customFields, mergeCustomFields, retries, connectionTimeout);
    }

    public void append(LogEvent event) {
        if (!this.checkEntryConditions()) {
            logger.warn("Appender not initialized. Dropping log entry");
            return;
        }
        String message = new String(this.getLayout().toByteArray(event));
        String loggerName = event.getLoggerName();
        long timestamp = event.getTimeMillis();
        String muleAppName = this.extractMuleAppName(message);
        logger.debug("Queueing message for New Relic: " + message);
        try {
            HashMap<String, Object> custom = new HashMap<String, Object>(this.extractcustom(event));
            for (Map.Entry<String, Object> entry : this.customFields.entrySet()) {
                custom.putIfAbsent(entry.getKey(), entry.getValue());
            }
            this.queue.add(new LogEntry(message, this.applicationName, muleAppName, this.logType, timestamp, custom, this.mergeCustomFields));
            if (this.queue.size() >= this.batchSize) {
                if (this.attempt == 0) {
                    boolean bStatus = this.flushQueue();
                    if (!bStatus) {
                        ++this.attempt;
                        logger.warn("Attempt {} failed. Retrying in next harvest cycle...", (Object)this.attempt);
                        logger.warn("batchsize check is now disabled due to unhealthy connection");
                    } else {
                        logger.debug("Batchsize-check: Successfully sent logs.");
                    }
                } else {
                    logger.debug("Skipping {}/{} sending log entries to New Relic ( batchsize check )  - harvest cycle did not report healthy connection", (Object)this.batchSize, (Object)this.queue.size());
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to insert log entry into log queue. ", (Throwable)e);
        }
    }

    private boolean flushQueue() {
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>();
        boolean bStatus = false;
        this.queue.drainTo(batch, this.batchSize);
        if (!batch.isEmpty()) {
            logger.debug("Flushing {}/{} log entries to New Relic", (Object)batch.size(), (Object)(this.queue.size() + batch.size()));
            bStatus = this.logForwarder.flush(batch, this.mergeCustomFields, this.customFields);
        }
        return bStatus;
    }

    private Map<String, Object> extractcustom(LogEvent event) {
        HashMap<String, Object> custom = new HashMap<String, Object>();
        event.getContextData().forEach(custom::put);
        return custom;
    }

    private String extractMuleAppName(String message) {
        Pattern pattern = Pattern.compile("\\[.*?\\]\\..*?\\[([^\\]]+)\\]");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "generic";
    }

    private boolean checkEntryConditions() {
        boolean initialized = this.logForwarder != null && this.logForwarder.isInitialized();
        logger.debug("Check entry conditions: " + initialized);
        return initialized;
    }

    private void startFlushingTask() {
        Runnable flushTask = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        logger.debug("Flushing task running...");
                        ArrayList<LogEntry> batch = new ArrayList<LogEntry>();
                        NewRelicBatchingAppender.this.queue.drainTo(batch, NewRelicBatchingAppender.this.batchSize);
                        if (!batch.isEmpty()) {
                            logger.debug("Flushing {}/{} log entries to New Relic", (Object)batch.size(), (Object)(NewRelicBatchingAppender.this.queue.size() + batch.size()));
                            boolean success = NewRelicBatchingAppender.this.logForwarder.flush(batch, NewRelicBatchingAppender.this.mergeCustomFields, NewRelicBatchingAppender.this.customFields);
                            if (success) {
                                logger.debug("Harvest Cycle: Successfully sent logs.");
                                NewRelicBatchingAppender.this.attempt = 0;
                            } else {
                                NewRelicBatchingAppender.this.attempt++;
                                logger.warn("Attempt {} failed. Retrying in next cycle...", (Object)NewRelicBatchingAppender.this.attempt);
                            }
                            if (NewRelicBatchingAppender.this.attempt >= NewRelicBatchingAppender.this.maxRetries) {
                                logger.error("Exhausted all retry attempts across cycles. Discarding {} logs.", (Object)NewRelicBatchingAppender.this.queue.size());
                                NewRelicBatchingAppender.this.queue.clear();
                                NewRelicBatchingAppender.this.attempt = 0;
                                logger.debug("Queue Size: {} ", (Object)NewRelicBatchingAppender.this.queue.size());
                            }
                        }
                        Thread.sleep(NewRelicBatchingAppender.this.flushInterval);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("Flushing task interrupted", (Throwable)e);
                    return;
                }
            }
        };
        Thread flushThread = new Thread(flushTask);
        flushThread.setDaemon(true);
        flushThread.start();
        logger.info("NewRelicBatchingAppender initialized with settings: batchSize={}, maxMessageSize={}, flushInterval={}", (Object)this.batchSize, (Object)this.maxMessageSize, (Object)this.flushInterval);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        logger.debug("Stopping NewRelicBatchingAppender {}", (Object)this.getName());
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        try {
            this.logForwarder.close(this.mergeCustomFields, this.customFields);
        }
        catch (Exception e) {
            logger.error("Unable to close appender", (Throwable)e);
        }
        this.setStopped();
        logger.debug("NewRelicBatchingAppender {} has been stopped", (Object)this.getName());
        return stopped;
    }
}

