/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.labs;

import com.newrelic.labs.NRBufferWithEviction;
import com.newrelic.labs.NRCostBoundedConcurrentQueue;
import java.util.Collection;

public class NRBufferWithFifoEviction<T>
extends NRBufferWithEviction<T> {
    private final NRCostBoundedConcurrentQueue<T> queue;
    private final NRCostBoundedConcurrentQueue.CostAssigner<T> costAssigner;

    public NRBufferWithFifoEviction(long capacity, NRCostBoundedConcurrentQueue.CostAssigner<T> costAssigner) {
        super(capacity);
        this.queue = new NRCostBoundedConcurrentQueue<T>(capacity, costAssigner);
        this.costAssigner = costAssigner;
    }

    @Override
    protected T evict() {
        return this.queue.poll();
    }

    @Override
    protected boolean evict(long cost) {
        if (cost > this.getCapacity()) {
            return false;
        }
        long targetCost = this.getCapacity() - cost;
        while (this.queue.cost() > targetCost) {
            this.evict();
        }
        return true;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public int drainTo(Collection<T> collection, int atMost) {
        return this.queue.drainTo(collection, atMost);
    }

    @Override
    public boolean add(T element) {
        boolean wasSuccessful = this.queue.offer(element);
        if (!wasSuccessful) {
            this.evict(this.costAssigner.cost(element));
            return this.queue.offer(element);
        }
        return true;
    }

    public synchronized void clear() {
        this.queue.clear();
    }
}

