/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.labs;

import com.newrelic.labs.FlushCallback;
import com.newrelic.labs.LogEntry;
import com.newrelic.labs.LogForwarder;
import com.newrelic.labs.NRBufferWithFifoEviction;
import com.newrelic.labs.NRCostBoundedConcurrentQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="NewRelicBatchingAppender", category="Core", elementType="appender", printObject=true)
public class NewRelicBatchingAppender
extends AbstractAppender {
    private static final Logger logger = StatusLogger.getLogger();
    private static final int DEFAULT_BATCH_SIZE = 2000;
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final long DEFAULT_MAX_MESSAGE_SIZE = 0x100000L;
    private static final long DEFAULT_FLUSH_INTERVAL = 120000L;
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final String LOG_TYPE = "muleLog";
    private static final String LOG_URL = "https://log-api.newrelic.com/log/v1";
    private static final boolean MERGE_CUSTOM_FIELDS = false;
    private static final long DEFAULT_MAX_QUEUE_SIZE_BYTES = 0x200000L;
    private final NRBufferWithFifoEviction<LogEntry> queue;
    private final String apiKey;
    private final String apiUrl;
    private final String applicationName;
    private final String logType;
    private final boolean mergeCustomFields;
    private final String name;
    private final LogForwarder logForwarder;
    private int attempt = 0;
    private final int batchSize;
    private final int connPoolSize;
    private final long maxMessageSize;
    private final long flushInterval;
    private final long queueCapacity;
    private final long timeout;
    private final Map<String, Object> customFields;
    private final int maxRetries;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    @PluginFactory
    public static NewRelicBatchingAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="apiKey") String apiKey, @PluginAttribute(value="apiUrl") String apiUrl, @PluginAttribute(value="applicationName") String applicationName, @PluginAttribute(value="batchSize") Integer batchSize, @PluginAttribute(value="maxMessageSize") Long maxMessageSize, @PluginAttribute(value="logType") String logType, @PluginAttribute(value="flushInterval") Long flushInterval, @PluginAttribute(value="queueCapacity") Long queueCapacity, @PluginAttribute(value="customFields") String customFields, @PluginAttribute(value="mergeCustomFields") Boolean mergeCustomFields, @PluginAttribute(value="maxRetries") Integer maxRetries, @PluginAttribute(value="timeout") Long timeout, @PluginAttribute(value="connPoolSize") Integer connPoolSize) {
        if (name == null) {
            logger.error("No name provided for NewRelicBatchingAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (apiKey == null || applicationName == null) {
            logger.error("API key, and application name must be provided for NewRelicBatchingAppender");
            return null;
        }
        if (apiUrl == null || apiUrl.length() == 0) {
            apiUrl = LOG_URL;
        }
        int retries = maxRetries != null ? maxRetries : 3;
        long connectionTimeout = timeout != null ? timeout : 30000L;
        return new NewRelicBatchingAppender(name, filter, (Layout<? extends Serializable>)layout, true, apiKey, apiUrl, applicationName, batchSize, maxMessageSize, flushInterval, queueCapacity, logType, customFields, mergeCustomFields, retries, connectionTimeout, connPoolSize);
    }

    protected NewRelicBatchingAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String apiKey, String apiUrl, String applicationName, Integer batchSize, Long maxMessageSize, Long flushInterval, Long queueCapacity, String logType, String customFields, Boolean mergeCustomFields, int maxRetries, long timeout, Integer connPoolSize) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.queueCapacity = queueCapacity != null && queueCapacity > 0L ? queueCapacity : 0x200000L;
        NRCostBoundedConcurrentQueue.CostAssigner<LogEntry> logEntryCostAssigner = logEntry -> {
            long cost = 0L;
            if (logEntry.getMessage() != null) {
                cost += (long)logEntry.getMessage().length();
            }
            if (logEntry.getApplicationName() != null) {
                cost += (long)logEntry.getApplicationName().length();
            }
            if (logEntry.getLogType() != null) {
                cost += (long)logEntry.getLogType().length();
            }
            if (logEntry.getName() != null) {
                cost += (long)logEntry.getName().length();
            }
            return cost += 8L;
        };
        this.queue = new NRBufferWithFifoEviction<LogEntry>(this.queueCapacity, logEntryCostAssigner);
        this.apiKey = apiKey;
        this.apiUrl = apiUrl;
        this.applicationName = applicationName;
        this.name = name;
        this.timeout = timeout > 0L ? timeout : 30000L;
        this.maxRetries = maxRetries > 0 ? maxRetries : 3;
        this.batchSize = batchSize != null && batchSize > 0 ? batchSize : 2000;
        this.connPoolSize = connPoolSize != null && connPoolSize > 0 ? connPoolSize : 5;
        this.maxMessageSize = maxMessageSize != null && maxMessageSize > 0L ? maxMessageSize : 0x100000L;
        this.flushInterval = flushInterval != null && flushInterval > 0L ? flushInterval : 120000L;
        this.logType = logType != null && logType.length() > 0 ? logType : LOG_TYPE;
        this.customFields = this.parsecustomFields(customFields);
        this.mergeCustomFields = mergeCustomFields != null ? mergeCustomFields : false;
        this.logForwarder = new LogForwarder(apiKey, apiUrl, this.maxMessageSize, this.queue, maxRetries, timeout, connPoolSize);
        this.startFlushingTask();
    }

    public void append(LogEvent event) {
        if (!this.checkEntryConditions()) {
            logger.warn("Appender not initialized. Dropping log entry");
            return;
        }
        String message = new String(this.getLayout().toByteArray(event));
        String loggerName = event.getLoggerName();
        long timestamp = event.getTimeMillis();
        String muleAppName = this.extractMuleAppName(message);
        logger.debug("Queueing message for New Relic: " + message);
        try {
            HashMap<String, Object> custom = new HashMap<String, Object>(this.extractcustom(event));
            for (Map.Entry<String, Object> entry : this.customFields.entrySet()) {
                custom.putIfAbsent(entry.getKey(), entry.getValue());
            }
            this.queue.add(new LogEntry(message, this.applicationName, muleAppName, this.logType, timestamp, custom, this.mergeCustomFields));
            if (this.queue.size() >= this.batchSize) {
                this.flushQueueAsync();
            }
        }
        catch (Exception e) {
            logger.error("Unable to insert log entry into log queue. ", (Throwable)e);
        }
    }

    private boolean checkEntryConditions() {
        boolean initialized = this.logForwarder != null && this.logForwarder.isInitialized();
        logger.debug("Check entry conditions: " + initialized);
        return initialized;
    }

    private Map<String, Object> extractcustom(LogEvent event) {
        HashMap<String, Object> custom = new HashMap<String, Object>();
        event.getContextData().forEach(custom::put);
        return custom;
    }

    private String extractMuleAppName(String message) {
        Pattern pattern = Pattern.compile("\\[.*?\\]\\..*?\\[([^\\]]+)\\]");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "generic";
    }

    private void flushQueueAsync() {
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>();
        this.queue.drainTo((Collection<LogEntry>)batch, this.batchSize);
        if (!batch.isEmpty()) {
            this.logForwarder.flushAsync(batch, this.mergeCustomFields, this.customFields, new FlushCallback(){

                @Override
                public void onFailure(List<Map<String, Object>> failedLogEvents) {
                    logger.warn("Flush failed. Requeuing logs...");
                    NewRelicBatchingAppender.this.requeueLogs(failedLogEvents);
                    NewRelicBatchingAppender.this.attempt++;
                    if (NewRelicBatchingAppender.this.attempt >= NewRelicBatchingAppender.this.maxRetries) {
                        logger.error("Exhausted all retry attempts. Discarding logs.");
                        NewRelicBatchingAppender.this.attempt = 0;
                    }
                }

                @Override
                public void onSuccess() {
                    logger.debug("Flush successful.");
                    NewRelicBatchingAppender.this.attempt = 0;
                }
            });
        }
    }

    private Map<String, Object> parsecustomFields(String customFields) {
        HashMap<String, Object> custom = new HashMap<String, Object>();
        if (customFields != null && !customFields.isEmpty()) {
            String[] pairs;
            for (String pair : pairs = customFields.split(",")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length != 2) continue;
                custom.put(keyValue[0], keyValue[1]);
            }
        }
        return custom;
    }

    private void requeueLogs(List<Map<String, Object>> logEvents) {
        for (Map<String, Object> logEvent : logEvents) {
            try {
                LogEntry logEntry = this.logForwarder.convertToLogEntry(logEvent);
                boolean added = this.queue.add(logEntry);
                if (added) continue;
                System.err.println("Failed to requeue log entry due to size constraints.");
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to convert log event to LogEntry: " + logEvent);
            }
        }
    }

    public void shutdown() {
        this.flushQueueAsync();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void startFlushingTask() {
        Runnable flushTask = () -> {
            try {
                logger.debug("Flushing task running... ");
                ArrayList<LogEntry> batch = new ArrayList<LogEntry>();
                this.queue.drainTo((Collection<LogEntry>)batch, this.batchSize);
                if (!batch.isEmpty()) {
                    logger.debug("Flushing {}/{} log entries to New Relic", (Object)batch.size(), (Object)(this.queue.size() + batch.size()));
                    this.logForwarder.flushAsync(batch, this.mergeCustomFields, this.customFields, new FlushCallback(){

                        @Override
                        public void onFailure(List<Map<String, Object>> failedLogEvents) {
                            logger.warn("Flush failed. Requeuing logs...");
                            NewRelicBatchingAppender.this.requeueLogs(failedLogEvents);
                            NewRelicBatchingAppender.this.attempt++;
                            if (NewRelicBatchingAppender.this.attempt >= NewRelicBatchingAppender.this.maxRetries) {
                                logger.error("Exhausted all retry attempts. Discarding logs.");
                                NewRelicBatchingAppender.this.attempt = 0;
                            }
                        }

                        @Override
                        public void onSuccess() {
                            logger.debug("Harvest Cycle: Successfully sent logs.");
                            NewRelicBatchingAppender.this.attempt = 0;
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.error("Error during flushing task", (Throwable)e);
            }
        };
        this.scheduler.scheduleAtFixedRate(flushTask, 0L, this.flushInterval, TimeUnit.MILLISECONDS);
        logger.info("NewRelicBatchingAppender initialized with settings: batchSize={}, maxMessageSize={}, flushInterval={}, queueCapacity={}, maxRetries={}, mergeCustomFields={}, connPoolSize={}, timeout={}", (Object)this.batchSize, (Object)this.maxMessageSize, (Object)this.flushInterval, (Object)this.queueCapacity, (Object)this.maxRetries, (Object)this.mergeCustomFields, (Object)this.connPoolSize, (Object)this.timeout);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        logger.debug("Stopping NewRelicBatchingAppender {}", (Object)this.getName());
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        try {
            this.logForwarder.close(this.mergeCustomFields, this.customFields);
            this.scheduler.shutdown();
            if (!this.scheduler.awaitTermination(timeout, timeUnit)) {
                this.scheduler.shutdownNow();
                if (!this.scheduler.awaitTermination(timeout, timeUnit)) {
                    logger.error("Scheduler did not terminate");
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to close appender", (Throwable)e);
        }
        this.setStopped();
        logger.debug("NewRelicBatchingAppender {} has been stopped", (Object)this.getName());
        return stopped;
    }
}

