/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.labs;

import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MessageObfuscator {
    public static String obfuscateMessageRandom(String message, String commaSeparatedPatterns) {
        if (message == null || message.isEmpty() || commaSeparatedPatterns == null || commaSeparatedPatterns.isEmpty()) {
            return message;
        }
        String[] regexPatternsArray = commaSeparatedPatterns.split("\\^\\^");
        for (int i = 0; i < regexPatternsArray.length; ++i) {
            regexPatternsArray[i] = regexPatternsArray[i].trim();
        }
        StringBuilder obfuscatedMessage = new StringBuilder(message);
        Random random = new Random();
        for (String regex : regexPatternsArray) {
            try {
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(obfuscatedMessage);
                ArrayList<int[]> matches = new ArrayList<int[]>();
                while (matcher.find()) {
                    matches.add(new int[]{matcher.start(), matcher.end()});
                }
                for (int i = matches.size() - 1; i >= 0; --i) {
                    int[] indices;
                    int start = ((int[])matches.get(i))[0];
                    int end = ((int[])matches.get(i))[1];
                    int length = end - start;
                    if (length == 0) continue;
                    char[] chars = obfuscatedMessage.substring(start, end).toCharArray();
                    int numToObfuscate = length == 1 ? 1 : 1 + random.nextInt(length - 1);
                    for (int index : indices = random.ints(0, length).distinct().limit(numToObfuscate).toArray()) {
                        chars[index] = 88;
                    }
                    obfuscatedMessage.replace(start, end, new String(chars));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return obfuscatedMessage.toString();
    }

    public static String obfuscateMessage(String message, String commaSeparatedPatterns) {
        if (message == null || message.isEmpty() || commaSeparatedPatterns == null || commaSeparatedPatterns.isEmpty()) {
            return message;
        }
        String[] regexPatternsArray = commaSeparatedPatterns.split("\\^\\^");
        for (int i = 0; i < regexPatternsArray.length; ++i) {
            regexPatternsArray[i] = regexPatternsArray[i].trim();
        }
        StringBuilder obfuscatedMessage = new StringBuilder(message);
        for (String regex : regexPatternsArray) {
            try {
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(obfuscatedMessage);
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    int length = end - start;
                    StringBuilder replacement = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        replacement.append('X');
                    }
                    obfuscatedMessage.replace(start, end, replacement.toString());
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return obfuscatedMessage.toString();
    }

    public static void main(String[] args) {
        System.out.println("--- Message Obfuscation Test Cases ---");
        String message1 = "INFO  MyAPI [[MuleRuntime].uber.01: [samplemuleapp].samplemuleappFlow.BLOCKING @24508028]: {\"glossary\":{\"title\":\"My credit card number is 1234-5678-9012-3456 and expires on 12/25\",\"GlossDiv\":{\"title\":\"S\",\"GlossList\":{\"GlossEntry\":{\"ID\":\"SGML\",\"SortAs\":\"SGML\",\"GlossTerm\":\"Standard Generalized Markup Language\",\"Acronym\":\"SGML\",\"Abbrev\":\"ISO 8879:1986\",\"GlossDef\":{\"para\":\"A meta-markup language, used to create markup languages such as DocBook.\",\"GlossSeeAlso\":[\"GML\",\"XML\"]},\"GlossSee\":\"markup\"}}}}}.";
        String patterns1 = "\\d{4}-\\d{4}-\\d{4}-\\d{4}^^\\d{2}/\\d{2}";
        String obfuscated1 = MessageObfuscator.obfuscateMessage(message1, patterns1);
        System.out.println("\n---Confugured patterns---" + patterns1);
        System.out.println("\nOriginal Message 1: " + message1);
        System.out.println("Obfuscated Message 1: " + obfuscated1);
        String message2 = "Contact me at john.doe@example.com or call 123-456-7890.";
        String patterns2 = "\\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}\\b^^\\d{3}-\\d{3}-\\d{4}";
        String obfuscated2 = MessageObfuscator.obfuscateMessage(message2, patterns2);
        System.out.println("\n--- Confugured patterns ---" + patterns2);
        System.out.println("\nOriginal Message 2: " + message2);
        System.out.println("Obfuscated Message 2: " + obfuscated2);
        String message3 = "The secret code is CODE123 and another is CODE789. Also, CODE000.";
        String patterns3 = "CODE\\d{3}";
        String obfuscated3 = MessageObfuscator.obfuscateMessage(message3, patterns3);
        System.out.println("\n--- Confugured patterns ---" + patterns3);
        System.out.println("\nOriginal Message 3: " + message3);
        System.out.println("Obfuscated Message 3: " + obfuscated3);
        String message4 = "This message has no sensitive data.";
        String patterns4 = "\\d{5}";
        String obfuscated4 = MessageObfuscator.obfuscateMessage(message4, patterns4);
        System.out.println("\n--- Confugured patterns ---" + patterns4);
        System.out.println("\nOriginal Message 4: " + message4);
        System.out.println("Obfuscated Message 4: " + obfuscated4);
        String message5 = "";
        String patterns5 = ".*";
        String obfuscated5 = MessageObfuscator.obfuscateMessage(message5, patterns5);
        System.out.println("\n--- Confugured patterns ---" + patterns5);
        System.out.println("\nOriginal Message 5: \"" + message5 + "\"");
        System.out.println("Obfuscated Message 5: \"" + obfuscated5 + "\"");
        String message6 = null;
        String patterns6 = ".*";
        System.out.println("\n---Confugured patterns ---" + patterns6);
        String obfuscated6 = MessageObfuscator.obfuscateMessage(message6, patterns6);
        System.out.println("\nOriginal Message 6: " + message6);
        System.out.println("Obfuscated Message 6: " + obfuscated6);
        String message7 = "Some text with a secret.";
        String patterns7 = null;
        String obfuscated7 = MessageObfuscator.obfuscateMessage(message7, patterns7);
        System.out.println("\n--- Confugured patterns ---" + patterns7);
        System.out.println("\nOriginal Message 7: " + message7);
        System.out.println("Obfuscated Message 7: " + obfuscated7);
        String message8 = "Some text with another secret.";
        String patterns8 = "";
        String obfuscated8 = MessageObfuscator.obfuscateMessage(message8, patterns8);
        System.out.println("\n--- Confugured patterns ---" + patterns8);
        System.out.println("\nOriginal Message 8: " + message8);
        System.out.println("Obfuscated Message 8: " + obfuscated8);
        String message9 = "The value is ABCDE12345.";
        String patterns9 = "ABCDE\\d{5}^^\\d{5}";
        String obfuscated9 = MessageObfuscator.obfuscateMessage(message9, patterns9);
        System.out.println("\n--- Confugured patterns ---" + patterns9);
        System.out.println("\nOriginal Message 9: " + message9);
        System.out.println("Obfuscated Message 9: " + obfuscated9);
        String message10 = "This message has an [invalid regex pattern].";
        String patterns10 = "[^^pattern";
        System.out.println("\n--- Confugured patterns ---" + patterns10);
        String obfuscated10 = MessageObfuscator.obfuscateMessage(message10, patterns10);
        System.out.println("\nOriginal Message 10: " + message10);
        System.out.println("Obfuscated Message 10: " + obfuscated10);
        String message11 = "A B C D E";
        String patterns11 = "B^^D";
        String obfuscated11 = MessageObfuscator.obfuscateMessage(message11, patterns11);
        System.out.println("\n--- Confugured patterns ---" + patterns11);
        System.out.println("\nOriginal Message 11: " + message11);
        System.out.println("Obfuscated Message 11: " + obfuscated11);
    }
}

