/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.labs;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class NRCostBoundedConcurrentQueue<T> {
    private final LinkedBlockingQueue<T> queue;
    private final CostAssigner<T> costAssigner;
    private final long capacity;
    private final AtomicLong cost = new AtomicLong(0L);

    public NRCostBoundedConcurrentQueue(long capacity, CostAssigner<T> costAssigner) {
        this.queue = new LinkedBlockingQueue();
        this.costAssigner = costAssigner;
        this.capacity = capacity;
    }

    public long cost() {
        return this.cost.get();
    }

    public int size() {
        return this.queue.size();
    }

    public int drainTo(Collection<T> collection, int atMost) {
        assert (collection.isEmpty());
        int elementsDrained = this.queue.drainTo(collection, atMost);
        for (T e : collection) {
            this.cost.addAndGet(-this.costAssigner.cost(e));
        }
        return elementsDrained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(T e) {
        long eCost = this.costAssigner.cost(e);
        NRCostBoundedConcurrentQueue nRCostBoundedConcurrentQueue = this;
        synchronized (nRCostBoundedConcurrentQueue) {
            if (eCost + this.cost.get() > this.capacity) {
                return false;
            }
            this.cost.addAndGet(eCost);
        }
        return this.queue.add(e);
    }

    public T poll() {
        T e = this.queue.poll();
        if (e != null) {
            this.cost.addAndGet(-this.costAssigner.cost(e));
        }
        return e;
    }

    public synchronized void clear() {
        this.queue.clear();
        this.cost.set(0L);
    }

    public static interface CostAssigner<T> {
        public long cost(T var1);
    }
}

