/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.config;

import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.OTelSdkConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.CustomAttributesConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.SpanGenerationConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.exporter.metric.OtlpMetricExporterConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.exporter.trace.OtlpTraceExporterConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.resource.OTelResourceConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.connection.OTelMule4ObservablityAgentConnectionProvider;
import org.mule.extension.otel.mule4.observablity.agent.internal.connection.OtelSdkConnection;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.OTelMuleNotificationHandler;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.listener.MuleMessageProcessorNotificationListener;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.listener.MulePipelineNotificationListener;
import org.mule.extension.otel.mule4.observablity.agent.internal.operations.OTelMule4ObservablityAgentOperations;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={OTelMule4ObservablityAgentOperations.class})
@ConnectionProviders(value={OTelMule4ObservablityAgentConnectionProvider.class})
public class OTelMule4ObservablityAgentConfiguration
implements Startable {
    private static Logger logger = LoggerFactory.getLogger(OTelMule4ObservablityAgentConfiguration.class);
    @Parameter
    @DisplayName(value="DISABLE all Signals")
    @Summary(value="Enable/Disable all tracing and metric signal gathering in this application.  If disabled, all other configuration details will be ignored.")
    @Optional(defaultValue="false")
    private boolean disableAllSignals;
    @ParameterGroup(name="Resource")
    @Placement(order=20)
    @Summary(value="Open Telemetry Resource Configuration. An OpenTelemetry Resource is an immutable representation of the entity producing telemetry specified as a set of attributes.")
    private OTelResourceConfig resource;
    @ParameterGroup(name="Trace Exporter Properties")
    @Summary(value="OpenTelemetry Protocol Trace Exporter Configuration.  <b>Note:  System or Environment Variables will BE overriden by this configuration.</b>")
    private OtlpTraceExporterConfig traceExporter;
    @ParameterGroup(name="Metric Exporter Properties")
    @Summary(value="OpenTelemetry Protocol Metric Exporter Configuration.  <b>Note:  System or Environment Variables will BE overriden by this configuration.</b>")
    private OtlpMetricExporterConfig metricExporter;
    @ParameterGroup(name="Span Generation Bypass")
    @Summary(value="Select if Message Processors spans should be added to the trace in general.  You can bypass certain Message Processors by adding them to list below.")
    private SpanGenerationConfig spanGenerationConfig;
    @ParameterGroup(name="Custom Attributes")
    @Summary(value=" Key-Value pairs of custom (application specific) attributes.")
    private CustomAttributesConfig customAttributesConfig;
    @Inject
    NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    MuleConfiguration muleConfiguration;
    @Inject
    ExpressionManager expressionManager;

    public boolean getdisableAllSignals() {
        return this.disableAllSignals;
    }

    public OTelResourceConfig getResource() {
        return this.resource;
    }

    public OtlpMetricExporterConfig getMetricExporter() {
        return this.metricExporter;
    }

    public OtlpTraceExporterConfig getTraceExporter() {
        return this.traceExporter;
    }

    public SpanGenerationConfig getSpanGenerationConfig() {
        return this.spanGenerationConfig;
    }

    public CustomAttributesConfig getCustomAttributesConfig() {
        return this.customAttributesConfig;
    }

    public void start() throws MuleException {
        logger.info("OTelMule4ObservablityAgentConfiguration starting");
        if (this.getdisableAllSignals()) {
            System.setProperty("mule.otel.processor.interceptor.enable", "false");
            logger.info("Signal processing is DISABLED");
            return;
        }
        System.setProperty("mule.otel.processor.interceptor.enable", "true");
        logger.info("Signal processing is ENABLED");
        Supplier<OtelSdkConnection> otelSdkConnection = () -> OtelSdkConnection.getInstance(new OTelSdkConfig(this.getResource(), this.getTraceExporter(), this.getMetricExporter(), this.muleConfiguration, this.getSpanGenerationConfig(), this.expressionManager, this.getCustomAttributesConfig()));
        OTelMuleNotificationHandler otelMuleNotificationHandler = new OTelMuleNotificationHandler(otelSdkConnection);
        this.notificationListenerRegistry.registerListener((NotificationListener)new MuleMessageProcessorNotificationListener(otelMuleNotificationHandler));
        this.notificationListenerRegistry.registerListener((NotificationListener)new MulePipelineNotificationListener(otelMuleNotificationHandler));
    }
}

