/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.config.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.resource.Attribute;
import org.mule.extension.otel.mule4.observablity.agent.internal.util.KeyValuePair;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="resource")
@Summary(value="This class stores configuration details regarding the source of the telemetry data(signals) in the form of Attributes.")
public class OTelResourceConfig {
    @Parameter
    @Summary(value="Logical (unique) name for this application (e.g., shoppingcart, productAPI, ...).")
    private String serviceName;
    @Parameter
    @Summary(value="Optional attributes for this application defined as <key,value> pairs(e.g., service.namespace:com.mycompany, service.version:0.0.1, ...). Attributes provide context to a distributed trace which can help with correlations to proivde a clear view of what was involved when performance changes occur.")
    @Optional
    @NullSafe
    private List<Attribute> resourceAttributes;

    public String getServiceName() {
        return this.serviceName;
    }

    public List<Attribute> getResourceAttributes() {
        return this.resourceAttributes;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otel.service.name", this.getServiceName());
        config.put("otel.resource.attributes", KeyValuePair.commaSeparatedList(this.getResourceAttributes()));
        return Collections.unmodifiableMap(config);
    }

    public String toString() {
        return StringUtils.join((Object[])new Map[]{this.getProperties()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTelResourceConfig that = (OTelResourceConfig)o;
        return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.resourceAttributes, that.resourceAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.resourceAttributes);
    }
}

