/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.connection;

import java.util.function.Supplier;
import org.mule.extension.otel.mule4.observablity.agent.internal.connection.OtelSdkConnection;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTelMule4ObservablityAgentConnectionProvider
implements CachedConnectionProvider<OtelSdkConnection>,
NoConnectivityTest {
    private final Logger LOGGER = LoggerFactory.getLogger(OTelMule4ObservablityAgentConnectionProvider.class);

    public OtelSdkConnection connect() throws ConnectionException {
        Supplier<ConnectionException> connectionExecption = OTelMule4ObservablityAgentConnectionProvider::connectionException;
        return OtelSdkConnection.get().orElseThrow(connectionExecption);
    }

    public void disconnect(OtelSdkConnection connection) {
        try {
            connection.invalidate();
        }
        catch (Exception e) {
            this.LOGGER.error("Error while disconnecting from the Otel SDK: " + e.getMessage(), (Throwable)e);
        }
    }

    public ConnectionValidationResult validate(OtelSdkConnection connection) {
        return ConnectionValidationResult.success();
    }

    public static ConnectionException connectionException() {
        return new ConnectionException("Cannot get an OpenTelemetry SDK connection before the SDK is initialized");
    }
}

