/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.connection;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.OTelSdkConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.CustomAttributesConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.config.advanced.SpanGenerationConfig;
import org.mule.extension.otel.mule4.observablity.agent.internal.metric.MuleMetricMemoryUsage;
import org.mule.extension.otel.mule4.observablity.agent.internal.metric.MuleMetricSystemWorkload;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OtelSdkConnection {
    private static final Logger logger = LoggerFactory.getLogger(OtelSdkConnection.class);
    private final OpenTelemetry openTelemetry;
    private static OtelSdkConnection otelSdkConnection;
    private final Tracer tracer;
    private final TextMapPropagator textMapPropagator;
    private final MuleConfiguration muleConfiguration;
    private final SpanGenerationConfig spanGenerationConfig;
    private final ExpressionManager expressionManager;
    private final CustomAttributesConfig customAttributesConfig;

    private OtelSdkConnection(String name, String version, OTelSdkConfig otelSdkConfig) {
        logger.info("Initializing the OpenTelemetry Mule 4 Observability Agent {}:{}", (Object)name, (Object)version);
        AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder();
        if (otelSdkConfig != null) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (otelSdkConfig.getResourceConfig() != null) {
                configMap.putAll(otelSdkConfig.getResourceConfig().getProperties());
            }
            if (otelSdkConfig.getTraceExporterConfig() != null) {
                configMap.putAll(otelSdkConfig.getTraceExporterConfig().getProperties());
            }
            if (otelSdkConfig.getMetricExporterConfig() != null) {
                configMap.putAll(otelSdkConfig.getMetricExporterConfig().getProperties());
            }
            Supplier<Map> propertiesSupplier = () -> Collections.unmodifiableMap(configMap);
            builder.addPropertiesSupplier(propertiesSupplier);
        }
        this.openTelemetry = builder.build().getOpenTelemetrySdk();
        this.tracer = this.openTelemetry.getTracer(name, version);
        this.textMapPropagator = this.openTelemetry.getPropagators().getTextMapPropagator();
        this.muleConfiguration = otelSdkConfig.getMuleConfiguration();
        this.expressionManager = otelSdkConfig.getExpressionManager();
        this.spanGenerationConfig = otelSdkConfig.getSpanGenerationConfig();
        this.customAttributesConfig = otelSdkConfig.getCustomAttributesConfig();
        MuleMetricMemoryUsage.setInstance(this.openTelemetry);
        MuleMetricSystemWorkload.setInstance(this.openTelemetry);
    }

    public void invalidate() {
    }

    public static Optional<OtelSdkConnection> get() {
        return Optional.ofNullable(otelSdkConnection);
    }

    public static synchronized OtelSdkConnection getInstance(OTelSdkConfig otelSdkConfig) {
        if (otelSdkConnection == null) {
            otelSdkConnection = new OtelSdkConnection("org.mulesoft.extension.otel.mule4.observability.agent", OtelSdkConnection.getAgentVersion(otelSdkConfig), otelSdkConfig);
        }
        return otelSdkConnection;
    }

    private static String getAgentVersion(OTelSdkConfig otelSdkConfig) {
        String version = "0.0.1";
        try {
            DefaultMuleConfiguration defaultMuleConfiguration = (DefaultMuleConfiguration)otelSdkConfig.getMuleConfiguration();
            String filePath = defaultMuleConfiguration.getMuleHomeDirectory() + "/apps/" + defaultMuleConfiguration.getDataFolderName() + "/META-INF/mule-artifact/classloader-model.json";
            JsonElement jsonElement = JsonParser.parseReader((Reader)new FileReader(filePath));
            if (!jsonElement.isJsonObject()) {
                return version;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (!jsonObject.has("dependencies")) {
                return version;
            }
            Iterator dependenciesIt = jsonObject.get("dependencies").getAsJsonArray().iterator();
            while (dependenciesIt.hasNext()) {
                Set dependencySet = ((JsonElement)dependenciesIt.next()).getAsJsonObject().entrySet();
                for (Map.Entry entry : dependencySet) {
                    JsonObject jo;
                    if (((JsonElement)entry.getValue()).isJsonObject() && (jo = ((JsonElement)entry.getValue()).getAsJsonObject()).has("artifactId")) {
                        String artificatId = jo.get("artifactId").getAsString();
                        if (!artificatId.equalsIgnoreCase("otel-mule4-observability-agent")) break;
                        version = jo.get("version").getAsString();
                        break;
                    }
                    logger.debug("Entry:  " + entry.toString());
                }
                if (version.equalsIgnoreCase("0.0.1")) continue;
                break;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        return version;
    }

    public synchronized Optional<Tracer> getTracer() {
        return Optional.ofNullable(this.tracer);
    }

    public synchronized Optional<TextMapPropagator> getTextMapPropagator() {
        return Optional.ofNullable(this.textMapPropagator);
    }

    public Optional<MuleConfiguration> getMuleConfiguration() {
        return Optional.ofNullable(this.muleConfiguration);
    }

    public Optional<SpanGenerationConfig> getSpanGenerationConfig() {
        return Optional.ofNullable(this.spanGenerationConfig);
    }

    public Optional<ExpressionManager> getExpressionManager() {
        return Optional.ofNullable(this.expressionManager);
    }

    public Optional<CustomAttributesConfig> getCustomAttributesConfig() {
        return Optional.ofNullable(this.customAttributesConfig);
    }
}

