/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.otel.mule4.observablity.agent.internal.context.propagation.OTelContextPropagator;
import org.mule.extension.otel.mule4.observablity.agent.internal.interceptor.TracingProcessorInterceptorFactory;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.metadata.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TracingProcessorInterceptor
implements ProcessorInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TracingProcessorInterceptor.class);

    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        String traceId = event.getCorrelationId();
        if (TracingProcessorInterceptorFactory.isFirstProcessor(location)) {
            try {
                event.addVariable("OTEL_TRACE_CONTEXT", OTelContextPropagator.makeTraceContextMapFor(traceId));
                logger.debug("created TRACE_CONTEXT_MAP_KEY variable for MuleSoft traceId (correlationId): " + traceId);
            }
            catch (Exception e) {
                logger.debug("unable to create TRACE_CONTEXT_MAP_KEY variable.  \nError: " + e.getMessage());
            }
        } else if (this.isHttpRequestProcessor(location)) {
            // empty if block
        }
    }

    public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
        if (this.isLoggerProcessor(location)) {
            ProcessorParameterValue processorParameterValue = parameters.get("message");
            try {
                String message = processorParameterValue.resolveValue().toString();
                event.addVariable("__LOGGER_OUTPUT_KEY__", (Object)message, DataType.JSON_STRING);
                logger.debug("around::Intercepted a logger message resolved: " + message);
            }
            catch (Exception e) {
                logger.debug("around::Intercepted logger processor resolved with error: " + e.getMessage());
            }
            logger.debug("around::Intercepted a logger processor");
        }
        return action.proceed();
    }

    public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        if (this.isLoggerProcessor(location)) {
            logger.debug("around::Intercepted a logger processor");
        }
    }

    private boolean isHttpRequestProcessor(ComponentLocation location) {
        return TracingProcessorInterceptorFactory.isProcessorType(location, "http:request");
    }

    private boolean isLoggerProcessor(ComponentLocation location) {
        return TracingProcessorInterceptorFactory.isProcessorType(location, "mule:logger");
    }
}

