/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.mule.extension.otel.mule4.observablity.agent.internal.notification.parser.service.provider.NotificationParser;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class NotificationParserService {
    private static NotificationParserService service;
    private final List<NotificationParser> notificationParsers;

    private NotificationParserService() {
        ServiceLoader<NotificationParser> loader = ServiceLoader.load(NotificationParser.class, NotificationParser.class.getClassLoader());
        ArrayList list = new ArrayList();
        loader.iterator().forEachRemaining(list::add);
        this.notificationParsers = Collections.unmodifiableList(list);
    }

    public static synchronized NotificationParserService getInstance() {
        if (service == null) {
            service = new NotificationParserService();
        }
        return service;
    }

    public Optional<NotificationParser> getParserFor(EnrichedServerNotification notification) {
        return this.notificationParsers.stream().filter(np -> np.canParse(notification)).findFirst();
    }
}

